/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.common.gzip;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;

@NoJSR250Annotations
public class GZIPFeature
extends AbstractFeature {
    private static final GZIPInInterceptor IN = new GZIPInInterceptor();
    private static final GZIPOutInterceptor OUT = new GZIPOutInterceptor();
    int threshold = -1;

    @Override
    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        provider.getInInterceptors().add(IN);
        if (this.threshold == -1) {
            provider.getOutInterceptors().add(OUT);
            provider.getOutFaultInterceptors().add(OUT);
        } else {
            GZIPOutInterceptor out = new GZIPOutInterceptor();
            out.setThreshold(this.threshold);
            this.remove(provider.getOutInterceptors());
            this.remove(provider.getOutFaultInterceptors());
            provider.getOutInterceptors().add(out);
            provider.getOutFaultInterceptors().add(out);
        }
    }

    private void remove(List<Interceptor<? extends Message>> outInterceptors) {
        int x = outInterceptors.size();
        while (x > 0) {
            if (!(outInterceptors.get(--x) instanceof GZIPOutInterceptor)) continue;
            outInterceptors.remove(x);
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }
}

