/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.spring;

import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.configuration.jsse.spring.TLSClientParametersConfig;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HttpConduitBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String HTTP_NS = "http://cxf.apache.org/transports/http/configuration";

    @Override
    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        bean.setAbstract(true);
        this.mapElementToJaxbProperty(element, bean, new QName(HTTP_NS, "client"), "client", HTTPClientPolicy.class);
        this.mapElementToJaxbProperty(element, bean, new QName(HTTP_NS, "proxyAuthorization"), "proxyAuthorization", ProxyAuthorizationPolicy.class);
        this.mapElementToJaxbProperty(element, bean, new QName(HTTP_NS, "authorization"), "authorization", AuthorizationPolicy.class);
        this.mapSpecificElements(element, bean);
    }

    private void mapSpecificElements(Element parent, BeanDefinitionBuilder bean) {
        Node n = parent.getFirstChild();
        while (n != null) {
            if (1 != n.getNodeType() || !HTTP_NS.equals(n.getNamespaceURI())) {
                n = n.getNextSibling();
                continue;
            }
            String elementName = n.getLocalName();
            if ("trustDecider".equals(elementName)) {
                this.mapBeanOrClassElement((Element)n, bean, MessageTrustDecider.class);
            } else if ("authSupplier".equals(elementName)) {
                this.mapBeanOrClassElement((Element)n, bean, HttpAuthSupplier.class);
            } else if ("basicAuthSupplier".equals(elementName)) {
                this.mapBeanOrClassElement((Element)n, bean, HttpAuthSupplier.class);
            } else if ("tlsClientParameters".equals(elementName)) {
                this.mapTLSClientParameters((Element)n, bean);
            }
            n = n.getNextSibling();
        }
    }

    public void mapTLSClientParameters(Element n, BeanDefinitionBuilder bean) {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlWriter = StaxUtils.createXMLStreamWriter(writer);
        try {
            StaxUtils.copy(n, xmlWriter);
            xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        BeanDefinitionBuilder jaxbbean = BeanDefinitionBuilder.rootBeanDefinition(TLSClientParametersConfig.class);
        jaxbbean.getRawBeanDefinition().setFactoryMethodName("createTLSClientParameters");
        jaxbbean.addConstructorArg((Object)writer.toString());
        bean.addPropertyValue("tlsClientParameters", (Object)jaxbbean.getBeanDefinition());
    }

    protected void mapBeanOrClassElement(Element element, BeanDefinitionBuilder bean, Class elementClass) {
        String beanref;
        String elementName = element.getLocalName();
        String classProperty = element.getAttribute("class");
        if (classProperty != null && !classProperty.equals("")) {
            try {
                Object obj = ClassLoaderUtils.loadClass(classProperty, ((Object)((Object)this)).getClass()).newInstance();
                if (!elementClass.isInstance(obj)) {
                    throw new IllegalArgumentException("Element '" + elementName + "' must be of type " + elementClass.getName() + ".");
                }
                bean.addPropertyValue(elementName, obj);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Element '" + elementName + "' could not load " + classProperty + " - " + ex);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Element '" + elementName + "' could not load " + classProperty + " - " + ex);
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("Element '" + elementName + "' could not load " + classProperty + " - " + ex);
            }
        }
        if ((beanref = element.getAttribute("bean")) != null && !beanref.equals("")) {
            if (classProperty != null && !classProperty.equals("")) {
                throw new IllegalArgumentException("Element '" + elementName + "' cannot have both " + "\"bean\" and \"class\" attributes.");
            }
            bean.addPropertyReference(elementName, beanref);
        } else if (classProperty == null || classProperty.equals("")) {
            throw new IllegalArgumentException("Element '" + elementName + "' requires at least one of the " + "\"bean\" or \"class\" attributes.");
        }
    }

    @Override
    protected Class getBeanClass(Element arg0) {
        return HTTPConduit.class;
    }
}

