/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https_jetty;

import java.security.SecureRandom;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.https.SSLUtils;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;

public class CXFJettySslSocketConnector
extends SslSelectChannelConnector {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFJettySslSocketConnector.class);
    protected KeyManager[] keyManagers;
    protected TrustManager[] trustManagers;
    protected SecureRandom secureRandom;
    protected List<String> cipherSuites;
    protected FiltersType cipherSuitesFilter;

    protected void setCipherSuites(List<String> cs) {
        this.cipherSuites = cs;
    }

    protected void setCipherSuitesFilter(FiltersType filter) {
        this.cipherSuitesFilter = filter;
    }

    protected void setKeyManagers(KeyManager[] kmgrs) {
        this.keyManagers = kmgrs;
    }

    protected void setTrustManagers(TrustManager[] tmgrs) {
        this.trustManagers = tmgrs;
    }

    protected void setSecureRandom(SecureRandom random) {
        this.secureRandom = random;
    }

    protected void setClientAuthentication(ClientAuthentication clientAuth) {
        this.getSslContextFactory().setWantClientAuth(true);
        if (clientAuth != null) {
            if (clientAuth.isSetWant()) {
                this.getSslContextFactory().setWantClientAuth(clientAuth.isWant());
            }
            if (clientAuth.isSetRequired()) {
                this.getSslContextFactory().setNeedClientAuth(clientAuth.isRequired());
            }
        }
    }

    protected void doStart() throws Exception {
        this.getSslContextFactory().setSslContext(this.createSSLContext());
        super.doStart();
    }

    protected SSLContext createSSLContext() throws Exception {
        String proto = this.getSslContextFactory().getProtocol() == null ? "TLS" : this.getSslContextFactory().getProtocol();
        SSLContext context = this.getSslContextFactory().getProvider() == null ? SSLContext.getInstance(proto) : SSLContext.getInstance(proto, this.getSslContextFactory().getProvider());
        context.init(this.keyManagers, this.trustManagers, this.secureRandom);
        String[] cs = SSLUtils.getCiphersuites(this.cipherSuites, SSLUtils.getServerSupportedCipherSuites(context), this.cipherSuitesFilter, LOG, true);
        this.getSslContextFactory().setExcludeCipherSuites(cs);
        return context;
    }
}

