/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class CXFServlet
extends CXFNonSpringServlet {
    @Override
    protected void loadBus(ServletConfig sc) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc.getServletContext());
        String configLocation = sc.getInitParameter("config-location");
        if (configLocation == null) {
            try {
                InputStream is = sc.getServletContext().getResourceAsStream("/WEB-INF/cxf-servlet.xml");
                if (is != null && is.available() > 0) {
                    is.close();
                    configLocation = "/WEB-INF/cxf-servlet.xml";
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (configLocation != null) {
            wac = this.createSpringContext((ApplicationContext)wac, sc, configLocation);
        }
        if (wac != null) {
            this.setBus((Bus)wac.getBean("cxf", Bus.class));
        } else {
            this.setBus(BusFactory.newInstance().createBus());
        }
    }

    private ApplicationContext createSpringContext(ApplicationContext ctx, ServletConfig sc, String location) {
        XmlWebApplicationContext ctx2 = new XmlWebApplicationContext();
        ctx2.setServletConfig(sc);
        Resource r = ctx2.getResource(location);
        try {
            InputStream in = r.getInputStream();
            in.close();
        }
        catch (IOException e) {
            r = ctx2.getResource("classpath:" + location);
            try {
                r.getInputStream().close();
            }
            catch (IOException e2) {
                r = null;
            }
        }
        try {
            if (r != null) {
                location = r.getURL().toExternalForm();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (ctx != null) {
            ctx2.setParent(ctx);
            String[] names = ctx.getBeanNamesForType(Bus.class);
            if (names == null || names.length == 0) {
                ctx2.setConfigLocations(new String[]{"classpath:/META-INF/cxf/cxf.xml", location});
            } else {
                ctx2.setConfigLocations(new String[]{location});
            }
        } else {
            ctx2.setConfigLocations(new String[]{"classpath:/META-INF/cxf/cxf.xml", location});
        }
        ctx2.refresh();
        return ctx2;
    }
}

