/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet.servicelist;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.servicelist.FormattedServiceListWriter;
import org.apache.cxf.transport.servlet.servicelist.ServiceListWriter;
import org.apache.cxf.transport.servlet.servicelist.UnformattedServiceListWriter;

public class ServiceListGeneratorServlet
extends HttpServlet {
    private DestinationRegistry destinationRegistry;
    private Bus bus;
    private String serviceListStyleSheet;
    private String title;

    public ServiceListGeneratorServlet(DestinationRegistry destinationRegistry, Bus bus) {
        this.destinationRegistry = destinationRegistry;
        this.bus = bus;
        this.title = "CXF - Service list";
    }

    public void setServiceListStyleSheet(String serviceListStyleSheet) {
        this.serviceListStyleSheet = serviceListStyleSheet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServiceListWriter serviceListWriter;
        HashMap<String, String> atomMap;
        ArrayList<String> privateEndpoints;
        PrintWriter writer = response.getWriter();
        AbstractDestination[] destinations = this.destinationRegistry.getSortedDestinations();
        if (request.getParameter("stylesheet") != null) {
            this.renderStyleSheet(request, response);
            return;
        }
        if (this.bus != null) {
            privateEndpoints = (List)this.bus.getProperty("org.apache.cxf.private.endpoints");
            atomMap = (Map)this.bus.getProperty("org.apache.cxf.extensions.logging.atom.pull");
        } else {
            privateEndpoints = new ArrayList();
            atomMap = new HashMap();
        }
        AbstractDestination[] soapEndpoints = this.getSOAPEndpoints(destinations, privateEndpoints);
        AbstractDestination[] restEndpoints = this.getRestEndpoints(destinations, privateEndpoints);
        if ("false".equals(request.getParameter("formatted"))) {
            boolean renderWsdlList = "true".equals(request.getParameter("wsdlList"));
            serviceListWriter = new UnformattedServiceListWriter(renderWsdlList);
        } else {
            String styleSheetPath = this.serviceListStyleSheet != null ? request.getContextPath() + "/" + this.serviceListStyleSheet : request.getRequestURI() + "/?stylesheet=1";
            serviceListWriter = new FormattedServiceListWriter(styleSheetPath, this.title, atomMap);
        }
        response.setContentType(serviceListWriter.getContentType());
        serviceListWriter.writeServiceList(writer, soapEndpoints, restEndpoints);
    }

    private boolean isPrivate(EndpointInfo ei, List<String> privateEndpoints) {
        if (privateEndpoints != null) {
            for (String s : privateEndpoints) {
                if (!ei.getAddress().endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    private AbstractDestination[] getSOAPEndpoints(AbstractDestination[] destinations, List<String> privateEndpoints) {
        ArrayList<AbstractDestination> soapEndpoints = new ArrayList<AbstractDestination>();
        for (AbstractDestination sd : destinations) {
            if (null == sd.getEndpointInfo().getName() || null == sd.getEndpointInfo().getInterface() || this.isPrivate(sd.getEndpointInfo(), privateEndpoints)) continue;
            soapEndpoints.add(sd);
        }
        return soapEndpoints.toArray(new AbstractDestination[0]);
    }

    private AbstractDestination[] getRestEndpoints(AbstractDestination[] destinations, List<String> privateEndpoints) {
        ArrayList<AbstractDestination> restfulDests = new ArrayList<AbstractDestination>();
        for (AbstractDestination sd : destinations) {
            if (null != sd.getEndpointInfo().getInterface() || this.isPrivate(sd.getEndpointInfo(), privateEndpoints)) continue;
            restfulDests.add(sd);
        }
        return restfulDests.toArray(new AbstractDestination[0]);
    }

    private void renderStyleSheet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/css; charset=UTF-8");
        URL url = ((Object)((Object)this)).getClass().getResource("servicelist.css");
        if (url != null) {
            IOUtils.copy(url.openStream(), (OutputStream)response.getOutputStream());
        }
    }

    public void init(ServletConfig servletConfig) {
        String configTitle;
        String configServiceListStyleSheet = servletConfig.getInitParameter("service-list-stylesheet");
        if (configServiceListStyleSheet != null) {
            this.serviceListStyleSheet = configServiceListStyleSheet;
        }
        if ((configTitle = servletConfig.getInitParameter("service-list-title")) != null) {
            this.title = configTitle;
        }
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return null;
    }

    public void destroy() {
    }
}

