/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSamlPolicyValidator;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

public class SamlTokenPolicyValidator
extends AbstractSamlPolicyValidator {
    private List<WSSecurityEngineResult> signedResults;
    private Element soapBody;
    private Message message;

    public SamlTokenPolicyValidator(Element soapBody, List<WSSecurityEngineResult> signedResults, Message message) {
        this.soapBody = soapBody;
        this.signedResults = signedResults;
        this.message = message;
    }

    public boolean validatePolicy(AssertionInfoMap aim, WSSecurityEngineResult wser) {
        Collection samlAis = (Collection)aim.get(SP12Constants.SAML_TOKEN);
        if (samlAis != null && !samlAis.isEmpty()) {
            for (AssertionInfo ai : samlAis) {
                AssertionWrapper assertionWrapper = (AssertionWrapper)wser.get((Object)"saml-assertion");
                SamlToken samlToken = (SamlToken)ai.getAssertion();
                ai.setAsserted(true);
                if (!this.checkVersion(samlToken, assertionWrapper)) {
                    ai.setNotAsserted("Wrong SAML Version");
                    return false;
                }
                TLSSessionInfo tlsInfo = this.message.get(TLSSessionInfo.class);
                Certificate[] tlsCerts = null;
                if (tlsInfo != null) {
                    tlsCerts = tlsInfo.getPeerCertificates();
                }
                if (!this.checkHolderOfKey(assertionWrapper, this.signedResults, tlsCerts)) {
                    ai.setNotAsserted("Assertion fails holder-of-key requirements");
                    return false;
                }
                if (this.checkSenderVouches(assertionWrapper, tlsCerts)) continue;
                ai.setNotAsserted("Assertion fails sender-vouches requirements");
                return false;
            }
        }
        return true;
    }

    private boolean checkVersion(SamlToken samlToken, AssertionWrapper assertionWrapper) {
        if ((samlToken.isUseSamlVersion11Profile10() || samlToken.isUseSamlVersion11Profile11()) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
            return false;
        }
        return !samlToken.isUseSamlVersion20Profile11() || assertionWrapper.getSamlVersion() == SAMLVersion.VERSION_20;
    }

    private boolean checkSenderVouches(AssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        if (tlsCerts != null && tlsCerts.length > 0) {
            return true;
        }
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) continue;
            if (this.signedResults == null || this.signedResults.isEmpty()) {
                return false;
            }
            if (this.checkAssertionAndBodyAreSigned(assertionWrapper)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAssertionAndBodyAreSigned(AssertionWrapper assertionWrapper) {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List<WSDataRef> sl = CastUtils.cast((List)signedResult.get((Object)"data-ref-uris"));
            boolean assertionIsSigned = false;
            boolean bodyIsSigned = false;
            if (sl == null) continue;
            for (WSDataRef dataRef : sl) {
                Element se = dataRef.getProtectedElement();
                if (se == assertionWrapper.getElement()) {
                    assertionIsSigned = true;
                }
                if (se == this.soapBody) {
                    bodyIsSigned = true;
                }
                if (!assertionIsSigned || !bodyIsSigned) continue;
                return true;
            }
        }
        return false;
    }
}

