/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducerRP;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.AbsNotificationConsumerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.ComponentWsdl;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.petalslink.dsb.jbi.se.wsn.AddressingHelper;
import org.petalslink.dsb.jbi.se.wsn.ServiceEngine;
import org.petalslink.dsb.notification.commons.AbstractNotificationSender;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.commons.NotificationManagerImpl;
import org.petalslink.dsb.notification.commons.api.NotificationManager;
import org.petalslink.dsb.notification.service.NotificationProducerRPService;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.WSAMessageImpl;
import org.petalslink.dsb.soap.api.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NotificationEngine {
    private Logger logger;
    NotificationManager notificationManager;
    private URL topicNamespaces;
    private URL topicSet;
    private QName serviceName;
    private QName interfaceName;
    private String endpointName;
    private AbsNotificationConsumerEngine notificationConsumerEngine;
    private AbstractNotificationSender internalNotificationSender;
    Wsdl consumerWSDL;
    Wsdl producerWSDL;
    private Client client;
    private ServiceEngine serviceEngine;

    public NotificationEngine(Logger logger, URL topicSet, URL topicNamespaces, QName serviceName, QName interfaceName, String endpointName, Client client) {
        this.logger = logger;
        this.topicNamespaces = topicNamespaces;
        this.topicSet = topicSet;
        this.serviceName = serviceName;
        this.interfaceName = interfaceName;
        this.endpointName = endpointName;
        this.client = client;
    }

    public void init() {
        this.notificationManager = new NotificationManagerImpl(this.topicSet, this.topicNamespaces, this.serviceName, this.interfaceName, this.endpointName);
        this.internalNotificationSender = new AbstractNotificationSender(this.getNotificationManager().getNotificationProducerEngine()){

            protected String getProducerAddress() {
                return "jbi://" + NotificationEngine.this.endpointName;
            }

            protected void doNotify(Notify notify, String producerAddress, EndpointReferenceType currentConsumerEdp, String subscriptionId, QName topic, String dialect) throws NotificationException {
                if (currentConsumerEdp == null || currentConsumerEdp.getAddress() == null || currentConsumerEdp.getAddress().getValue() == null) {
                    NotificationEngine.this.logger.fine("No address found, do not send notification");
                    return;
                }
                if (NotificationEngine.this.logger.isLoggable(Level.FINE)) {
                    NotificationEngine.this.logger.fine("Need to send the message to a subscriber which is : " + currentConsumerEdp.getAddress().getValue());
                }
                URI uri = currentConsumerEdp.getAddress().getValue();
                WSAMessageImpl message = null;
                if (!AddressingHelper.isExternalService(uri)) {
                    System.out.println("Internal service : TODO NotificationEngine class!");
                    return;
                }
                message = new WSAMessageImpl(uri.toString());
                try {
                    Document payload = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                    message.setPayload(payload);
                    message.setOperation(WsnbConstants.NOTIFY_QNAME);
                    NotificationEngine.this.client.fireAndForget((Message)message);
                }
                catch (ClientException e) {
                    e.printStackTrace();
                }
                catch (WsnbException e) {
                    e.printStackTrace();
                }
            }
        };
        this.notificationConsumerEngine = new AbsNotificationConsumerEngine(this.logger){

            public void notify(Notify notify) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("--- Got a notify, forward to internal engine ---");
                    try {
                        Document doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                        this.logger.fine(XMLHelper.createStringFromDOMDocument((Node)doc));
                    }
                    catch (WsnbException e) {
                        e.printStackTrace();
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                    this.logger.fine("-------------------------");
                }
                try {
                    NotificationEngine.this.internalNotificationSender.notify(notify);
                }
                catch (NotificationException e) {
                    e.printStackTrace();
                }
            }
        };
        this.consumerWSDL = this.loadDocument("WS-NotificationConsumer.wsdl");
        this.producerWSDL = this.loadDocument("WS-NotificationProducer.wsdl");
        this.serviceEngine = new ServiceEngine();
        this.serviceEngine.addService((Service)new NotificationProducerRPService(null, null, null, null, null, (INotificationProducerRP)this.getNotificationManager().getNotificationProducerEngine()), new QName[]{new QName("http://docs.oasis-open.org/wsrf/r-2", "GetResourceProperty"), new QName("http://docs.oasis-open.org/wsrf/r-2", "UpdateResourceProperties")});
    }

    private Wsdl loadDocument(String string) {
        try {
            return new ComponentWsdl(UtilFactory.getWSDLUtil().createWsdlDescription(AbstractComponent.class.getResource("/" + string), true));
        }
        catch (WSDLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public Wsdl getConsumerWSDL() {
        return this.consumerWSDL;
    }

    public Wsdl getProducerWSDL() {
        return this.producerWSDL;
    }

    public AbsNotificationConsumerEngine getNotificationConsumerEngine() {
        return this.notificationConsumerEngine;
    }

    public ServiceEngine getServiceEngine() {
        return this.serviceEngine;
    }
}

