/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi.se.wsn.listeners;

import java.util.logging.Level;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.petalslink.dsb.jbi.se.wsn.Component;
import org.petalslink.dsb.jbi.se.wsn.NotificationEngine;
import org.petalslink.dsb.jbi.se.wsn.listeners.NotificationV2JBIListener;
import org.petalslink.dsb.soap.api.SimpleExchange;
import org.w3c.dom.Document;

public class JBIListener
extends NotificationV2JBIListener {
    public boolean onJBIMessage(Exchange exchange) {
        NotificationEngine engine = this.getNotificationEngine();
        try {
            if (exchange.isActiveStatus()) {
                if (exchange.getFault() != null) {
                    if (this.getLogger().isLoggable(Level.WARNING)) {
                        if (UtilFactory.getExchangeUtil().isPetalsException(exchange.getFault())) {
                            this.getLogger().warning("notification technical fault message content: " + UtilFactory.getSourceUtil().createString(exchange.getFault().getContent()));
                        } else {
                            this.getLogger().warning("notification business fault message content: " + UtilFactory.getSourceUtil().createString(exchange.getFault().getContent()));
                        }
                    }
                } else {
                    System.out.println("Got a message = " + exchange.getOperationName());
                    NormalizedMessage normalizedMessage = exchange.getInMessage();
                    Document document = UtilFactory.getSourceUtil().createDocument(normalizedMessage.getContent());
                    org.petalslink.dsb.soap.Exchange e = new org.petalslink.dsb.soap.Exchange();
                    e.setIn(document);
                    engine.getServiceEngine().invoke((SimpleExchange)e);
                    if (e.getOut() != null) {
                        normalizedMessage = exchange.getOutMessage();
                        normalizedMessage.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(document));
                        exchange.setOutMessage(normalizedMessage);
                    }
                    e.getFault();
                }
            }
        }
        catch (PEtALSCDKException e) {
            exchange.setError(new Exception(e));
        }
        catch (Exception e) {
            exchange.setError(new Exception(e));
        }
        return true;
    }

    NotificationEngine getNotificationEngine() {
        return ((Component)this.getComponent()).getNotificationEngine();
    }
}

