/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.service.poller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.service.poller.QuartzPollerServiceImpl;
import org.petalslink.dsb.service.poller.api.PollerException;
import org.petalslink.dsb.service.poller.api.PollerService;
import org.petalslink.dsb.service.poller.api.PollingContext;
import org.petalslink.dsb.service.poller.api.PollingManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzPollingManagerImpl
implements PollingManager {
    final Log logger = LogFactory.getLog(QuartzPollingManagerImpl.class);
    private SchedulerFactory sf;
    private Scheduler scheduler;
    private boolean started = false;

    public PollerService getPollerService(PollingContext context) throws PollerException {
        if (!this.started) {
            return null;
        }
        return new QuartzPollerServiceImpl(context, this.scheduler);
    }

    public synchronized void init() {
        if (this.started) {
            return;
        }
        this.sf = new StdSchedulerFactory();
        try {
            this.scheduler = this.sf.getScheduler();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        this.started = false;
    }
}

