/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class WrappedInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WrappedInInterceptor.class);

    public WrappedInInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) {
        if (this.isGET(message) && message.getContent(List.class) != null) {
            LOG.fine("WrappedInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        if (!StaxUtils.toNextElement(xmlReader)) {
            return;
        }
        BindingOperationInfo operation = message.getExchange().get(BindingOperationInfo.class);
        boolean requestor = this.isRequestor(message);
        if (operation == null) {
            String local = xmlReader.getLocalName();
            if (requestor && local.endsWith("Response")) {
                local = local.substring(0, local.length() - 8);
            }
            if ((operation = ServiceModelUtil.getOperation(message.getExchange(), local)) == null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, local), Fault.FAULT_CODE_CLIENT);
            }
        }
        ServiceInfo si = operation.getBinding().getService();
        DataReader<XMLStreamReader> dr = this.getDataReader(message);
        MessageContentsList objects = new MessageContentsList();
        MessageInfo msgInfo = this.setMessage(message, operation, requestor, si);
        if (operation.isUnwrappedCapable() && msgInfo.getMessageParts().get(0).getTypeClass() != null) {
            Object wrappedObject = dr.read(msgInfo.getMessageParts().get(0), xmlReader);
            objects.put(msgInfo.getMessageParts().get(0), wrappedObject);
        } else {
            if (operation.isUnwrappedCapable()) {
                operation = operation.getUnwrappedOperation();
            }
            msgInfo = this.setMessage(message, operation, requestor, si);
            List<MessagePartInfo> messageParts = msgInfo.getMessageParts();
            Iterator<MessagePartInfo> itr = messageParts.iterator();
            if (xmlReader.getEventType() == 1) {
                StaxUtils.nextEvent(xmlReader);
            }
            while (StaxUtils.toNextElement(xmlReader)) {
                MessagePartInfo part = itr.next();
                objects.put(part, dr.read(part, xmlReader));
            }
        }
        message.setContent(List.class, objects);
    }

    private MessageInfo setMessage(Message message, BindingOperationInfo operation, boolean requestor, ServiceInfo si) {
        MessageInfo msgInfo = this.getMessageInfo(message, operation, requestor);
        message.put(MessageInfo.class, msgInfo);
        message.getExchange().put(BindingOperationInfo.class, operation);
        message.getExchange().put(OperationInfo.class, operation.getOperationInfo());
        message.getExchange().setOneWay(operation.getOperationInfo().isOneWay());
        message.put("javax.xml.ws.wsdl.operation", operation.getName());
        QName serviceQName = si.getName();
        message.put("javax.xml.ws.wsdl.service", serviceQName);
        QName interfaceQName = si.getInterface().getName();
        message.put("javax.xml.ws.wsdl.interface", interfaceQName);
        EndpointInfo endpointInfo = message.getExchange().get(Endpoint.class).getEndpointInfo();
        QName portQName = endpointInfo.getName();
        message.put("javax.xml.ws.wsdl.port", portQName);
        String address = endpointInfo.getAddress();
        URI wsdlDescription = null;
        try {
            wsdlDescription = new URI(address + "?wsdl");
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        message.put("javax.xml.ws.wsdl.description", wsdlDescription);
        return msgInfo;
    }
}

