/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.ManagedBus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.JMXConnectorPolicyType;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.jmx.MBServerConnectorFactory;
import org.apache.cxf.management.jmx.export.runtime.ModelMBeanAssembler;

public class InstrumentationManagerImpl
extends JMXConnectorPolicyType
implements InstrumentationManager,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(InstrumentationManagerImpl.class);
    private static Map<String, String> mbeanServerIDMap = new HashMap<String, String>();
    private Bus bus;
    private MBServerConnectorFactory mcf;
    private MBeanServer mbs;
    private Set<ObjectName> busMBeans = new HashSet<ObjectName>();
    private boolean connectFailed;
    private String persistentBusId;
    private boolean createMBServerConnectorFactory = true;
    private String mbeanServerName = "org.apache.cxf";
    private boolean usePlatformMBeanServer;

    public Bus getBus() {
        return this.bus;
    }

    @Resource(name="cxf")
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setServerName(String s) {
        this.mbeanServerName = s;
    }

    public void setCreateMBServerConnectorFactory(boolean createMBServerConnectorFactory) {
        this.createMBServerConnectorFactory = createMBServerConnectorFactory;
    }

    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension(this, InstrumentationManager.class);
            BusLifeCycleManager blcm = this.bus.getExtension(BusLifeCycleManager.class);
            if (null != blcm) {
                blcm.registerLifeCycleListener(this);
            }
        }
    }

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            if (this.mbs == null) {
                if (this.usePlatformMBeanServer) {
                    this.mbs = ManagementFactory.getPlatformMBeanServer();
                } else {
                    String mbeanServerID = mbeanServerIDMap.get(this.mbeanServerName);
                    List servers = null;
                    if (mbeanServerID != null) {
                        servers = CastUtils.cast(MBeanServerFactory.findMBeanServer(mbeanServerID));
                    }
                    if (servers == null || servers.size() == 0) {
                        this.mbs = MBeanServerFactory.createMBeanServer(this.mbeanServerName);
                        try {
                            mbeanServerID = (String)this.mbs.getAttribute(this.getDelegateName(), "MBeanServerId");
                            mbeanServerIDMap.put(this.mbeanServerName, mbeanServerID);
                        }
                        catch (JMException jMException) {}
                    } else {
                        this.mbs = (MBeanServer)servers.get(0);
                    }
                }
            }
            if (this.createMBServerConnectorFactory) {
                this.mcf = MBServerConnectorFactory.getInstance();
                this.mcf.setMBeanServer(this.mbs);
                this.mcf.setThreaded(this.isThreaded());
                this.mcf.setDaemon(this.isDaemon());
                this.mcf.setServiceUrl(this.getJMXServiceURL());
                try {
                    this.mcf.createConnector();
                }
                catch (IOException ex) {
                    this.connectFailed = true;
                    LOG.log(Level.SEVERE, "START_CONNECTOR_FAILURE_MSG", new Object[]{ex});
                }
            }
            if (!this.connectFailed && null != this.bus) {
                try {
                    ManagedBus mbus = new ManagedBus(this.bus);
                    this.register(mbus);
                }
                catch (JMException jmex) {
                    LOG.log(Level.SEVERE, "REGISTER_FAILURE_MSG", new Object[]{this.bus, jmex});
                }
            }
        }
    }

    private ObjectName getDelegateName() throws JMException {
        try {
            return (ObjectName)MBeanServerDelegate.class.getField("DELEGATE_NAME").get(null);
        }
        catch (Throwable t) {
            try {
                return new ObjectName("JMImplementation:type=MBeanServerDelegate");
            }
            catch (MalformedObjectNameException e) {
                JMException jme = new JMException(e.getMessage());
                jme.initCause(e);
                throw jme;
            }
        }
    }

    @Override
    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    @Override
    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        if (!this.isEnabled() || this.connectFailed) {
            return;
        }
        try {
            this.registerMBeanWithServer(obj, this.persist(name), forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanAssembler assembler = new ModelMBeanAssembler();
            ModelMBeanInfo mbi = assembler.getModelMbeanInfo(obj.getClass());
            this.register(obj, name, mbi, forceRegistration);
        }
    }

    @Override
    public ObjectName register(ManagedComponent i) throws JMException {
        ObjectName name = this.register(i, false);
        return name;
    }

    @Override
    public ObjectName register(ManagedComponent i, boolean forceRegistration) throws JMException {
        ObjectName name = i.getObjectName();
        this.register(i, name, forceRegistration);
        return name;
    }

    @Override
    public void unregister(ManagedComponent component) throws JMException {
        ObjectName name = component.getObjectName();
        this.unregister(this.persist(name));
    }

    @Override
    public void unregister(ObjectName name) throws JMException {
        if (!this.isEnabled() || this.connectFailed) {
            return;
        }
        this.busMBeans.remove(name);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public void setServer(MBeanServer server) {
        this.mbs = server;
    }

    @Override
    public void shutdown() {
        Object[] mBeans;
        if (!this.isEnabled()) {
            return;
        }
        if (this.mcf != null) {
            try {
                this.mcf.destroy();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "STOP_CONNECTOR_FAILURE_MSG", new Object[]{ex});
            }
        }
        for (Object name : mBeans = this.busMBeans.toArray()) {
            this.busMBeans.remove((ObjectName)name);
            try {
                this.unregister((ObjectName)name);
            }
            catch (JMException jmex) {
                LOG.log(Level.SEVERE, "UNREGISTER_FAILURE_MSG", new Object[]{name, jmex});
            }
        }
    }

    @Override
    public void initComplete() {
    }

    @Override
    public void preShutdown() {
    }

    @Override
    public void postShutdown() {
        this.shutdown();
    }

    private void register(Object obj, ObjectName name, ModelMBeanInfo mbi, boolean forceRegistration) throws JMException {
        RequiredModelMBean rtMBean = (RequiredModelMBean)this.mbs.instantiate("javax.management.modelmbean.RequiredModelMBean");
        rtMBean.setModelMBeanInfo(mbi);
        try {
            rtMBean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException itotex) {
            throw new JMException(itotex.getMessage());
        }
        this.registerMBeanWithServer(rtMBean, this.persist(name), forceRegistration);
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance = null;
        try {
            instance = this.mbs.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.mbs.unregisterMBean(name);
                instance = this.mbs.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.busMBeans.add(name);
        }
    }

    @Override
    public String getPersistentBusId() {
        return this.persistentBusId;
    }

    @Override
    public void setPersistentBusId(String id) {
        this.persistentBusId = this.sanitize(id);
    }

    private ObjectName persist(ObjectName original) throws JMException {
        String originalStr;
        ObjectName persisted = original;
        if (this.persistentBusId != null && !"".equals(this.persistentBusId) && !this.persistentBusId.startsWith("${") && (originalStr = original.toString()).indexOf("bus.id") != -1) {
            String persistedStr = originalStr.replaceFirst("bus.id=" + this.bus.getId(), "bus.id=" + this.persistentBusId);
            persisted = new ObjectName(persistedStr);
        }
        return persisted;
    }

    private String sanitize(String in) {
        StringBuilder str = new StringBuilder(in.length());
        block3: for (int x = 0; x < in.length(); ++x) {
            char ch = in.charAt(x);
            switch (ch) {
                case ',': 
                case '/': 
                case ':': 
                case '=': 
                case '?': 
                case '\\': {
                    str.append('_');
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

