/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.StaxStreamFilter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.InTransformReader;
import org.apache.cxf.staxutils.transform.OutTransformWriter;
import org.apache.cxf.staxutils.transform.QNamesMap;

public final class TransformUtils {
    private TransformUtils() {
    }

    public static XMLStreamReader createNewReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        return reader == null ? StaxUtils.createXMLStreamReader(is) : reader;
    }

    public static XMLStreamWriter createNewWriterIfNeeded(XMLStreamWriter writer, OutputStream os) {
        return writer == null ? StaxUtils.createXMLStreamWriter(os) : writer;
    }

    public static XMLStreamWriter createTransformWriterIfNeeded(XMLStreamWriter writer, OutputStream os, Map<String, String> outElementsMap, List<String> outDropElements, Map<String, String> outAppendMap, boolean attributesToElements) {
        if (outElementsMap != null || outDropElements != null || outAppendMap != null || attributesToElements) {
            writer = TransformUtils.createNewWriterIfNeeded(writer, os);
            writer = new OutTransformWriter(writer, outElementsMap, outAppendMap, outDropElements, attributesToElements);
        }
        return writer;
    }

    public static XMLStreamReader createTransformReaderIfNeeded(XMLStreamReader reader, InputStream is, List<String> inDropElements, Map<String, String> inElementsMap, Map<String, String> inAppendMap, boolean blockOriginalReader) {
        if (inDropElements != null) {
            Set<QName> dropElements = XMLUtils.convertStringsToQNames(inDropElements);
            reader = StaxUtils.createFilteredReader(TransformUtils.createNewReaderIfNeeded(reader, is), new StaxStreamFilter(dropElements.toArray(new QName[0])));
        }
        if (inElementsMap != null || inAppendMap != null) {
            reader = new InTransformReader(TransformUtils.createNewReaderIfNeeded(reader, is), inElementsMap, inAppendMap, blockOriginalReader);
        }
        return reader;
    }

    protected static void convertToQNamesMap(Map<String, String> map, QNamesMap elementsMap, Map<String, String> nsMap) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                QName lname = XMLUtils.convertStringToQName(entry.getKey());
                QName rname = XMLUtils.convertStringToQName(entry.getValue());
                elementsMap.put(lname, rname);
                if (nsMap == null) continue;
                nsMap.put(lname.getNamespaceURI(), rname.getNamespaceURI());
            }
        }
    }

    protected static void convertToMapOfQNames(Map<String, String> map, Map<QName, QName> elementsMap) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                QName lname = XMLUtils.convertStringToQName(entry.getKey());
                QName rname = XMLUtils.convertStringToQName(entry.getValue());
                elementsMap.put(lname, rname);
            }
        }
    }
}

