/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolContainer;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineParser;
import org.apache.cxf.tools.util.URIParserUtil;

public abstract class AbstractToolContainer
implements ToolContainer {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractToolContainer.class);
    protected ToolSpec toolspec;
    protected ToolContext context;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    private String[] arguments;
    private boolean isVerbose;
    private boolean isQuiet;
    private CommandDocument commandDoc;
    private CommandLineParser parser;
    private OutputStream outOutputStream;
    private OutputStream errOutputStream;

    public AbstractToolContainer() {
    }

    public AbstractToolContainer(ToolSpec ts) throws BadUsageException {
        this.toolspec = ts;
    }

    @Override
    public void setArguments(String[] args) {
        if (args == null) {
            return;
        }
        this.arguments = new String[args.length];
        System.arraycopy(args, 0, this.arguments, 0, args.length);
        this.setMode(args);
        if (this.isQuietMode()) {
            this.redirectOutput();
        }
    }

    public void parseCommandLine() throws BadUsageException {
        if (this.toolspec != null) {
            this.parser = new CommandLineParser(this.toolspec);
            this.commandDoc = this.parser.parseArguments(this.arguments);
        }
    }

    public void setMode(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("-q".equals(args[i])) {
                this.isQuiet = true;
            }
            if ("-quiet".equals(args[i])) {
                this.isQuiet = true;
            }
            if ("-V".equals(args[i])) {
                this.isVerbose = true;
            }
            if (!"-verbose".equals(args[i])) continue;
            this.isVerbose = true;
        }
    }

    public void init() throws ToolException {
        if (this.toolspec == null) {
            Message message = new Message("TOOLSPEC_NOT_INITIALIZED", LOG, new Object[0]);
            LOG.log(Level.SEVERE, message.toString());
            throw new ToolException(message);
        }
    }

    public CommandDocument getCommandDocument() {
        return this.commandDoc;
    }

    public CommandLineParser getCommandLineParser() {
        return this.parser;
    }

    public void redirectOutput() {
        this.outOutputStream = new GenericOutputStream();
        this.errOutputStream = new GenericOutputStream();
    }

    public boolean isQuietMode() {
        return this.isQuiet;
    }

    public boolean isVerboseMode() {
        return this.isVerbose;
    }

    public String[] getArgument() {
        return this.arguments;
    }

    public OutputStream getOutOutputStream() {
        return this.outOutputStream;
    }

    @Override
    public void setOutOutputStream(OutputStream outOutputStream) {
        this.outOutputStream = outOutputStream;
        this.out = outOutputStream instanceof PrintStream ? (PrintStream)outOutputStream : new PrintStream(outOutputStream);
    }

    public OutputStream getErrOutputStream() {
        return this.errOutputStream;
    }

    @Override
    public void setErrOutputStream(OutputStream errOutputStream) {
        this.errOutputStream = errOutputStream;
        this.err = errOutputStream instanceof PrintStream ? (PrintStream)errOutputStream : new PrintStream(errOutputStream);
    }

    @Override
    public void setContext(ToolContext c) {
        this.context = c;
    }

    public ToolContext getContext() {
        if (this.context == null) {
            this.context = new ToolContext();
        }
        return this.context;
    }

    @Override
    public void execute(boolean exitOnFinish) throws ToolException {
        this.init();
        try {
            this.parseCommandLine();
        }
        catch (BadUsageException bue) {
            throw new ToolException(bue);
        }
    }

    public void tearDown() {
    }

    public Bus getBus() {
        Bus bus = BusFactory.getDefaultBus();
        OASISCatalogManager catalogManager = bus.getExtension(OASISCatalogManager.class);
        String catalogLocation = this.getCatalogURL();
        if (!StringUtils.isEmpty(catalogLocation)) {
            try {
                catalogManager.loadCatalog(new URI(catalogLocation).toURL());
            }
            catch (Exception e) {
                e.printStackTrace(this.err);
                throw new ToolException(new Message("FOUND_NO_FRONTEND", LOG, catalogLocation));
            }
        }
        return bus;
    }

    protected String getCatalogURL() {
        String catalogLocation = (String)this.context.get("catalog");
        return URIParserUtil.getAbsoluteURI(catalogLocation);
    }

    public class GenericOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }
    }
}

