/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.feature;

import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.ws.rm.RMDeliveryInterceptor;
import org.apache.cxf.ws.rm.RMInInterceptor;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMOutInterceptor;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.policy.RMAssertion;
import org.apache.cxf.ws.rm.soap.RMSoapInterceptor;

@NoJSR250Annotations
public class RMFeature
extends AbstractFeature {
    private RMAssertion rmAssertion;
    private DeliveryAssuranceType deliveryAssurance;
    private SourcePolicyType sourcePolicy;
    private DestinationPolicyType destinationPolicy;
    private RMStore store;
    private RMInInterceptor rmLogicalIn = new RMInInterceptor();
    private RMOutInterceptor rmLogicalOut = new RMOutInterceptor();
    private RMDeliveryInterceptor rmDelivery = new RMDeliveryInterceptor();
    private RMSoapInterceptor rmCodec = new RMSoapInterceptor();

    public void setDeliveryAssurance(DeliveryAssuranceType da) {
        this.deliveryAssurance = da;
    }

    public void setDestinationPolicy(DestinationPolicyType dp) {
        this.destinationPolicy = dp;
    }

    public void setRMAssertion(RMAssertion rma) {
        this.rmAssertion = rma;
    }

    public void setSourcePolicy(SourcePolicyType sp) {
        this.sourcePolicy = sp;
    }

    public void setStore(RMStore store) {
        this.store = store;
    }

    @Override
    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        RMManager manager = bus.getExtension(RMManager.class);
        if (null != this.rmAssertion) {
            manager.setRMAssertion(this.rmAssertion);
        }
        if (null != this.deliveryAssurance) {
            manager.setDeliveryAssurance(this.deliveryAssurance);
        }
        if (null != this.sourcePolicy) {
            manager.setSourcePolicy(this.sourcePolicy);
        }
        if (null != this.destinationPolicy) {
            manager.setDestinationPolicy(this.destinationPolicy);
        }
        if (null != this.store) {
            manager.setStore(this.store);
        }
        this.rmLogicalIn.setBus(bus);
        this.rmLogicalOut.setBus(bus);
        this.rmDelivery.setBus(bus);
        provider.getInInterceptors().add(this.rmLogicalIn);
        provider.getInInterceptors().add(this.rmCodec);
        provider.getInInterceptors().add(this.rmDelivery);
        provider.getOutInterceptors().add(this.rmLogicalOut);
        provider.getOutInterceptors().add(this.rmCodec);
        provider.getInFaultInterceptors().add(this.rmLogicalIn);
        provider.getInFaultInterceptors().add(this.rmCodec);
        provider.getInInterceptors().add(this.rmDelivery);
        provider.getOutFaultInterceptors().add(this.rmLogicalOut);
        provider.getOutFaultInterceptors().add(this.rmCodec);
    }
}

