/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignedPartsBuilder
implements AssertionBuilder<Element> {
    private static final QName[] KNOWN_ELEMENTS = new QName[]{SP11Constants.SIGNED_PARTS, SP12Constants.SIGNED_PARTS};

    public QName[] getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SignedEncryptedParts signedEncryptedParts = new SignedEncryptedParts(true, consts);
        for (Node nd = element.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (!(nd instanceof Element)) continue;
            this.processElement((Element)nd, signedEncryptedParts);
        }
        return signedEncryptedParts;
    }

    private void processElement(Element element, SignedEncryptedParts parent) {
        if ("Header".equals(element.getLocalName())) {
            String nameAttribute = element.getAttribute("Name");
            if (nameAttribute == null) {
                nameAttribute = "";
            }
            String namespaceAttribute = element.getAttribute("Namespace");
            parent.addHeader(new Header(nameAttribute, namespaceAttribute));
        } else if ("Body".equals(element.getLocalName())) {
            parent.setBody(true);
        }
    }
}

