/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.impl.NotificationProducerMgr;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.impl.SubscriptionManagerMgr;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.ComponentWsdl;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.NotificationController;
import org.ow2.petals.component.framework.api.notification.Transformer;
import org.ow2.petals.component.framework.notification.ComponentTransformer;
import org.ow2.petals.component.framework.notification.NotificationProducerReferenceSet;
import org.ow2.petals.component.framework.notification.Sender;
import org.ow2.petals.component.framework.util.UtilFactory;

public class ComponentNotificationController
implements NotificationController {
    private NotificationProducerMgr wsnbProducerService = null;
    private SubscriptionManagerMgr wsnbSubscriptionManagerService = null;
    private WstopTopicManager wstopTopicsMgr = null;
    private Logger logger = null;
    private Wsdl producerWsdl = null;
    private Wsdl consumerWsdl = null;
    private Map<String, NotificationProducerReferenceSet> notificationProducerReferenceMap = null;
    private Transformer transformer = null;
    private Sender sender = null;

    public ComponentNotificationController(ComponentContext componentContext, Logger logger, InputStream topicSet) throws WSDLException, WSNotificationExtensionException, WSNotificationException, MessagingException {
        SOAParameterType subscriptionSOAParameterType = null;
        SOAParameterType producerSOAParameterType = null;
        this.logger = logger;
        this.notificationProducerReferenceMap = new ConcurrentHashMap<String, NotificationProducerReferenceSet>(1);
        this.wstopTopicsMgr = new WstopTopicManager(topicSet);
        this.producerWsdl = new ComponentWsdl(UtilFactory.getWSDLUtil().createWsdlDescription(ComponentNotificationController.class.getResource("/WS-NotificationProducer.wsdl"), true));
        this.wsnbSubscriptionManagerService = new SubscriptionManagerMgr(logger, this.wstopTopicsMgr);
        subscriptionSOAParameterType = this.getSOAParameter(this.producerWsdl, Constants.Notification.SUBSCRIPTION_INTERFACE);
        this.wsnbSubscriptionManagerService.setSubscriptionsManagerInterface(subscriptionSOAParameterType.getInterface());
        this.wsnbSubscriptionManagerService.setSubscriptionsManagerService(subscriptionSOAParameterType.getService());
        this.wsnbSubscriptionManagerService.setSubscriptionsManagerEdp(subscriptionSOAParameterType.getEndpoint());
        producerSOAParameterType = this.getSOAParameter(this.producerWsdl, Constants.Notification.NOTIFICATION_PRODUCER_INTERFACE);
        this.wsnbProducerService = new NotificationProducerMgr(logger, this.wstopTopicsMgr, this.wsnbSubscriptionManagerService);
        this.wsnbProducerService.setNotificationProducerInterface(producerSOAParameterType.getInterface());
        this.wsnbProducerService.setNotificationProducerService(producerSOAParameterType.getService());
        this.wsnbProducerService.setNotificationProducerEdp(producerSOAParameterType.getEndpoint());
        this.consumerWsdl = new ComponentWsdl(UtilFactory.getWSDLUtil().createWsdlDescription(ComponentNotificationController.class.getResource("/WS-NotificationConsumer.wsdl"), true));
        this.transformer = new ComponentTransformer(producerSOAParameterType, subscriptionSOAParameterType, this.getSOAParameter(this.consumerWsdl, Constants.Notification.NOTIFICATION_CONSUMER_INTERFACE));
        this.sender = new Sender(componentContext);
    }

    private SOAParameterType getSOAParameter(Wsdl wsdl, QName qName) throws WSDLException, WSNotificationExtensionException {
        List endpointList = UtilFactory.getWSDLUtil().getEndpointList(wsdl.getDescription());
        if (endpointList != null) {
            for (Endpoint endpoint : endpointList) {
                if (endpoint == null || endpoint.getService() == null || ((Service)endpoint.getService()).getInterface() == null || ((InterfaceType)((Service)endpoint.getService()).getInterface()).getQName() == null || !qName.equals(((InterfaceType)((Service)endpoint.getService()).getInterface()).getQName())) continue;
                return this.convertToSOAParameter(endpoint);
            }
        }
        return null;
    }

    private SOAParameterType convertToSOAParameter(Endpoint endpoint) throws WSNotificationExtensionException, WSDLException {
        SOAParameterType soaParameter = null;
        soaParameter = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParameter.setInterface(((InterfaceType)((Service)endpoint.getService()).getInterface()).getQName());
        soaParameter.setService(((Service)endpoint.getService()).getQName());
        soaParameter.setEndpoint(endpoint.getName());
        return soaParameter;
    }

    public String registerPublisher(String topicExpressionNamespace, String topicExpression) throws WSNotificationException, WSAddressingException, WSNotificationExtensionException, MessagingException, PEtALSCDKException {
        this.logger.fine("Creating a register publisher...");
        RegisterPublisher registerPublisher = WSNotificationFactory.getInstance().createRegisterPublisher();
        registerPublisher = this.transformer.addNotificationProducerSOAParameter(registerPublisher);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("petals", topicExpressionNamespace);
        topic.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        topic.setContent("petals:" + topicExpression);
        registerPublisher.addTopic(topic);
        registerPublisher.setDemand(Boolean.valueOf(true));
        this.logger.fine("Register publisher created");
        RegisterPublisherResponse registerPublisherResponse = this.registerPublisher(registerPublisher);
        return this.getUuid(registerPublisherResponse);
    }

    public RegisterPublisherResponse registerPublisher(RegisterPublisher registerPublisher) throws WSNotificationException, WSAddressingException, WSNotificationExtensionException, MessagingException, PEtALSCDKException {
        EndpointReferenceType publisherRegistrationReference;
        this.logger.fine("Registering as publisher...");
        RegisterPublisherResponse registerPublisherResponse = this.sender.send(registerPublisher);
        String uuid = this.getUuid(registerPublisherResponse);
        if (uuid != null && (publisherRegistrationReference = registerPublisherResponse.getPublisherRegistrationReference()) != null) {
            NotificationProducerReferenceSet notificationProducerReferenceSet = new NotificationProducerReferenceSet();
            notificationProducerReferenceSet.setPublisherRegistrationReference(publisherRegistrationReference);
            if (registerPublisherResponse.getConsumerReference() != null) {
                EndpointReferenceType consumerReference = registerPublisherResponse.getConsumerReference();
                notificationProducerReferenceSet.setConsumerReference(consumerReference);
            }
            this.notificationProducerReferenceMap.put(uuid, notificationProducerReferenceSet);
            this.logger.fine("Publisher registered");
        }
        return registerPublisherResponse;
    }

    public void destroyRegistration(String registrationUuid) throws WSNotificationException, WSAddressingException, WSNotificationExtensionException, MessagingException, PEtALSCDKException {
        this.logger.fine("Creating a destroy registration...");
        DestroyRegistration destroyRegistration = WSNotificationFactory.getInstance().createDestroyRegistration();
        ResourcesUuidType resourcesUuidType = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        resourcesUuidType.addUuid(registrationUuid);
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)resourcesUuidType, (DestroyRegistration)destroyRegistration);
        this.logger.fine("Destroy registration created...");
        this.destroyRegistration(destroyRegistration);
    }

    public DestroyRegistrationResponse destroyRegistration(DestroyRegistration destroyRegistration) throws WSNotificationException, WSAddressingException, WSNotificationExtensionException, MessagingException, PEtALSCDKException {
        ReferenceParametersType referenceParametersType;
        EndpointReferenceType endpointReferenceType;
        NotificationProducerReferenceSet notificationProducerReferenceSet;
        DestroyRegistrationResponse destroyRegistrationResponse = null;
        this.logger.fine("Destroying the registration...");
        String registrationUuid = this.getUuid(destroyRegistration);
        if (registrationUuid != null && (notificationProducerReferenceSet = this.notificationProducerReferenceMap.get(registrationUuid)) != null && (endpointReferenceType = notificationProducerReferenceSet.getPublisherRegistrationReference()) != null && (referenceParametersType = (ReferenceParametersType)endpointReferenceType.getReferenceParameters()) != null && (destroyRegistrationResponse = this.sender.send(destroyRegistration, WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)referenceParametersType))) != null) {
            this.notificationProducerReferenceMap.remove(registrationUuid);
            this.logger.fine("Registration destroyed");
        }
        return destroyRegistrationResponse;
    }

    public Wsdl getProducerWsdl() {
        return this.producerWsdl;
    }

    public Wsdl getConsumerWsdl() {
        return this.consumerWsdl;
    }

    private String getUuid(RegisterPublisherResponse registerPublisherResponse) throws WSNotificationException, WSNotificationExtensionException, WSAddressingException {
        List uuidList;
        ResourcesUuidType resourcesUuidType;
        EndpointReferenceType publisherRegistrationReference;
        String uuid = null;
        if (registerPublisherResponse != null && (publisherRegistrationReference = registerPublisherResponse.getPublisherRegistrationReference()) != null && (resourcesUuidType = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)publisherRegistrationReference.getReferenceParameters()))) != null && (uuidList = resourcesUuidType.getUuids()) != null && uuidList.size() == 1) {
            uuid = (String)uuidList.get(0);
        }
        return uuid;
    }

    private String getUuid(DestroyRegistration destroyRegistration) throws WSNotificationException, WSNotificationExtensionException, WSAddressingException {
        List uuidList;
        ResourcesUuidType resourcesUuidType;
        String uuid = null;
        if (destroyRegistration != null && (resourcesUuidType = WsnSpecificTypeHelper.getResourcesUuidType((DestroyRegistration)destroyRegistration)) != null && (uuidList = resourcesUuidType.getUuids()) != null && uuidList.size() == 1) {
            uuid = (String)uuidList.get(0);
        }
        return uuid;
    }
}

