/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.notify;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.api.notification.notify.NotifyController;
import org.ow2.petals.component.framework.notification.notify.AbstractProducerComponentNotify;
import org.ow2.petals.component.framework.notification.notify.FaultProducerComponentNotify;
import org.ow2.petals.component.framework.notification.notify.InProducerComponentNotify;
import org.ow2.petals.component.framework.notification.notify.OutProducerComponentNotify;
import org.ow2.petals.component.framework.notification.notify.StatusProducerComponentNotify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNotifyController
implements NotifyController {
    private Map<EndpointReferenceType, List<AbstractProducerComponentNotify>> subscriptionMap = null;
    private NotificationBrokerController notificationBrokerController = null;
    private Logger logger = null;

    public ComponentNotifyController(NotificationBrokerController notificationBrokerController, Logger logger) {
        this.notificationBrokerController = notificationBrokerController;
        this.subscriptionMap = new ConcurrentHashMap<EndpointReferenceType, List<AbstractProducerComponentNotify>>();
        this.logger = logger;
    }

    public void add(EndpointReferenceType subscriptionReference, Subscribe subscribe) throws WSNotificationException, WSNotificationExtensionException, XPathExpressionException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        boolean notify = false;
        CopyOnWriteArrayList<AbstractProducerComponentNotify> componentNotifyList = null;
        List<AbstractProducerComponentNotify> candidateAbstractProducerComponentNotifyList = this.createCandidateAbstractProducerComponentNotifyList(subscriptionReference, subscribe);
        if (subscribe != null && subscribe.getFilter() != null) {
            for (AbstractProducerComponentNotify abstractProducerComponentNotify : candidateAbstractProducerComponentNotifyList) {
                notify = abstractProducerComponentNotify.getTopicExpressionFilter().isNotifiable(abstractProducerComponentNotify.getTopic());
                if (!notify) continue;
                if (componentNotifyList == null) {
                    componentNotifyList = new CopyOnWriteArrayList<AbstractProducerComponentNotify>();
                }
                componentNotifyList.add(abstractProducerComponentNotify);
            }
            if (componentNotifyList != null) {
                this.subscriptionMap.put(subscriptionReference, componentNotifyList);
            }
        }
    }

    private List<AbstractProducerComponentNotify> createCandidateAbstractProducerComponentNotifyList(EndpointReferenceType subscriptionReference, Subscribe subscribe) throws WSNotificationException, WSNotificationExtensionException, XPathExpressionException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        CopyOnWriteArrayList<AbstractProducerComponentNotify> candidateComponentNotifyList = new CopyOnWriteArrayList<AbstractProducerComponentNotify>();
        candidateComponentNotifyList.add(new InProducerComponentNotify(subscriptionReference, subscribe, this.notificationBrokerController, this.logger));
        candidateComponentNotifyList.add(new OutProducerComponentNotify(subscriptionReference, subscribe, this.notificationBrokerController, this.logger));
        candidateComponentNotifyList.add(new FaultProducerComponentNotify(subscriptionReference, subscribe, this.notificationBrokerController, this.logger));
        candidateComponentNotifyList.add(new StatusProducerComponentNotify(subscriptionReference, subscribe, this.notificationBrokerController, this.logger));
        return candidateComponentNotifyList;
    }

    public void remove(EndpointReferenceType endpointReferenceType) {
        this.subscriptionMap.remove(endpointReferenceType);
    }

    public void process(Class<?> clazz, Exchange exchange) {
        try {
            Iterator<List<AbstractProducerComponentNotify>> abstractProducerComponentNotifyListIterator = this.subscriptionMap.values().iterator();
            while (abstractProducerComponentNotifyListIterator.hasNext()) {
                for (AbstractProducerComponentNotify abstractProducerComponentNotify : abstractProducerComponentNotifyListIterator.next()) {
                    if (!clazz.isInstance(abstractProducerComponentNotify)) continue;
                    abstractProducerComponentNotify.process(exchange);
                }
            }
        }
        catch (MessagingException e) {
            this.logger.warning("unable to check the notification list");
            this.logger.fine("detail on the problem during the check of the notification list:" + e.getMessage());
        }
    }
}

