/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;
import org.ow2.petals.component.framework.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalListenerManager {
    private Map<String, List<AbstractExternalListener>> externalListeners;
    private AbstractComponent component;

    public ExternalListenerManager(AbstractComponent component) {
        this.component = component;
        this.externalListeners = new Hashtable<String, List<AbstractExternalListener>>();
    }

    public void createListeners(String serviceUnitName, List<Consumes> consumesList) throws PEtALSCDKException {
        for (Consumes consumes : consumesList) {
            AbstractExternalListener externalListener = this.createAndInitExternalListener(consumes);
            if (externalListener != null) {
                this.addExternalListerner(serviceUnitName, externalListener);
                continue;
            }
            throw new PEtALSCDKException("No ExternalListener can be created. Check if you have provided an ExternalListener class name in your component descriptor (jbi.xml)");
        }
    }

    public void startListening(String serviceUnitName) throws PEtALSCDKException {
        if (this.externalListeners.containsKey(serviceUnitName)) {
            for (AbstractExternalListener externalListener : this.externalListeners.get(serviceUnitName)) {
                externalListener.start();
            }
        }
    }

    public void stopListening(String serviceUnitName) throws PEtALSCDKException {
        if (this.externalListeners.containsKey(serviceUnitName)) {
            for (AbstractExternalListener externalListener : this.externalListeners.get(serviceUnitName)) {
                externalListener.stop();
            }
        }
    }

    public void removeListeners(String serviceUnitName) {
        this.externalListeners.remove(serviceUnitName);
    }

    private AbstractExternalListener createAndInitExternalListener(Consumes consumes) throws PEtALSCDKException {
        AbstractExternalListener externalListener = null;
        String externalListenerClassName = this.component.getComponentConfiguration().getExternalListenerClassName();
        if (!StringHelper.isNullOrEmpty(externalListenerClassName)) {
            try {
                ClassLoader componentClassLoader = this.getClass().getClassLoader();
                Class<?> clazz = componentClassLoader.loadClass(externalListenerClassName);
                externalListener = (AbstractExternalListener)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new PEtALSCDKException("Can't instanciate ExternaListener", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PEtALSCDKException("Can't instanciate ExternaListener", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new PEtALSCDKException("Can't find ExternaListener class : " + externalListenerClassName, (Throwable)e);
            }
            externalListener.init(this.component);
            externalListener.setConsumes(consumes);
            ConfigurationExtensions extensions = new ConfigurationExtensions(consumes.getAny());
            externalListener.setExtensions(extensions);
            externalListener.init();
        }
        return externalListener;
    }

    private void addExternalListerner(String serviceUnitName, AbstractExternalListener externalListener) {
        List<AbstractExternalListener> externalListenersForSU = this.externalListeners.get(serviceUnitName);
        if (externalListenersForSU == null) {
            externalListenersForSU = new ArrayList<AbstractExternalListener>();
            this.externalListeners.put(serviceUnitName, externalListenersForSU);
        }
        externalListenersForSU.add(externalListener);
    }
}

