/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.transform.DelegatingNamespaceContext;
import org.apache.cxf.staxutils.transform.QNamesMap;
import org.apache.cxf.staxutils.transform.TransformUtils;

public class InTransformReader
extends DepthXMLStreamReader {
    private static final String INTERN_NAMES = "org.codehaus.stax2.internNames";
    private static final String INTERN_NS = "org.codehaus.stax2.internNsUris";
    private QNamesMap inElementsMap;
    private Map<QName, QName> inAppendMap = new HashMap<QName, QName>(5);
    private Map<String, String> nsMap = new HashMap<String, String>(5);
    private QName currentQName;
    private QName previousQName;
    private int previousDepth = -1;
    private boolean blockOriginalReader = true;
    private DelegatingNamespaceContext namespaceContext;

    public InTransformReader(XMLStreamReader reader, Map<String, String> inMap, Map<String, String> appendMap, boolean blockOriginalReader) {
        super(reader);
        this.inElementsMap = new QNamesMap(inMap == null ? 0 : inMap.size());
        this.blockOriginalReader = blockOriginalReader;
        TransformUtils.convertToQNamesMap(inMap, this.inElementsMap, this.nsMap);
        TransformUtils.convertToMapOfQNames(appendMap, this.inAppendMap);
        this.namespaceContext = new DelegatingNamespaceContext(reader.getNamespaceContext(), this.nsMap);
    }

    @Override
    public XMLStreamReader getReader() {
        return this.blockOriginalReader ? this : super.getReader();
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.currentQName != null) {
            return 1;
        }
        if (this.previousDepth != -1 && this.previousDepth == this.getDepth() + 1) {
            this.previousDepth = -1;
            return 2;
        }
        return super.next();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (INTERN_NAMES.equals(name) || INTERN_NS.equals(name)) {
            return Boolean.FALSE;
        }
        return super.getProperty(name);
    }

    @Override
    public String getLocalName() {
        QName cQName = this.getCurrentName();
        if (cQName != null) {
            String name = cQName.getLocalPart();
            this.resetCurrentQName();
            return name;
        }
        return super.getLocalName();
    }

    private QName getCurrentName() {
        return this.currentQName != null ? this.currentQName : (this.previousQName != null ? this.previousQName : null);
    }

    private void resetCurrentQName() {
        this.currentQName = this.previousQName;
        this.previousQName = null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public String getPrefix() {
        QName name = this.readCurrentElement();
        String prefix = name.getPrefix();
        if (prefix.length() == 0) {
            prefix = this.namespaceContext.findUniquePrefix(name.getNamespaceURI());
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI(int index) {
        String ns = super.getNamespaceURI(index);
        String actualNs = this.nsMap.get(ns);
        if (actualNs != null) {
            return actualNs;
        }
        return ns;
    }

    @Override
    public String getNamespacePrefix(int index) {
        String ns = super.getNamespaceURI(index);
        String actualNs = this.nsMap.get(ns);
        if (actualNs != null) {
            return this.namespaceContext.findUniquePrefix(actualNs);
        }
        return this.namespaceContext.getPrefix(ns);
    }

    @Override
    public String getNamespaceURI() {
        QName theName = this.readCurrentElement();
        QName appendQName = this.inAppendMap.remove(theName);
        if (appendQName != null) {
            this.previousDepth = this.getDepth();
            this.previousQName = theName;
            this.currentQName = appendQName;
            return this.currentQName.getNamespaceURI();
        }
        QName expected = this.inElementsMap.get(theName);
        if (expected == null) {
            return theName.getNamespaceURI();
        }
        this.currentQName = expected;
        return this.currentQName.getNamespaceURI();
    }

    private QName readCurrentElement() {
        if (this.currentQName != null) {
            return this.currentQName;
        }
        String ns = super.getNamespaceURI();
        String name = super.getLocalName();
        String prefix = super.getPrefix();
        return new QName(ns, name, prefix == null ? "" : prefix);
    }

    @Override
    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName());
    }
}

