/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.service.factory.AnnotationsFactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListener;

@NoJSR250Annotations(unlessNull={"bus"})
public class FactoryBeanListenerManager {
    Bus bus;
    List<FactoryBeanListener> listeners = new CopyOnWriteArrayList<FactoryBeanListener>();

    public FactoryBeanListenerManager() {
        this.listeners.add(new AnnotationsFactoryBeanListener());
    }

    public FactoryBeanListenerManager(Bus b) {
        this();
        this.setBus(b);
    }

    @Resource
    public final void setBus(Bus bus) {
        this.bus = bus;
        this.bus.setExtension((Object)this, FactoryBeanListenerManager.class);
        ConfiguredBeanLocator loc = (ConfiguredBeanLocator)bus.getExtension(ConfiguredBeanLocator.class);
        if (loc != null) {
            for (FactoryBeanListener f : loc.getBeansOfType(FactoryBeanListener.class)) {
                if (this.listeners.contains(f)) continue;
                this.listeners.add(f);
            }
        }
    }

    public List<FactoryBeanListener> getListeners() {
        return this.listeners;
    }

    public void addListener(FactoryBeanListener l) {
        this.listeners.add(l);
    }

    public void removeListener(FactoryBeanListener l) {
        this.listeners.remove(l);
    }
}

