/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.cxf;

import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.petalslink.dsb.commons.service.api.Service;
import org.petalslink.dsb.jaxws.JAXWSHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFHelper {
    public static <T> T getClient(String baseURL, Class<T> clazz) {
        String address = baseURL;
        if (!address.endsWith("/")) {
            address = String.valueOf(address) + "/";
        }
        address = String.valueOf(address) + JAXWSHelper.getWebServiceName(clazz);
        return CXFHelper.getClientFromFinalURL(address, clazz);
    }

    public static <T> T getClientFromFinalURL(String fullURL, Class<T> clazz) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setAddress(fullURL);
        factory.setServiceClass(clazz);
        Object client = factory.create();
        return clazz.cast(client);
    }

    public static <T> Service getService(String baseURL, Class<T> clazz, Object bean) {
        String address;
        Class<?> wsClass = JAXWSHelper.getWebServiceClass(clazz);
        String serviceName = JAXWSHelper.getWebServiceName(wsClass);
        if (serviceName == null) {
            serviceName = clazz.getSimpleName();
        }
        if (!(address = baseURL).endsWith("/")) {
            address = String.valueOf(address) + "/";
        }
        address = String.valueOf(address) + serviceName;
        return CXFHelper.getServiceFromFinalURL(address, clazz, bean);
    }

    public static <T> Service getServiceFromFinalURL(final String finalURL, Class<T> clazz, Object bean) {
        final JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.setDataBinding((DataBinding)new JAXBDataBinding());
        sf.setServiceBean(bean);
        Class<?> wsClass = JAXWSHelper.getWebServiceClass(clazz);
        sf.setAddress(finalURL);
        sf.setServiceClass(wsClass);
        return new Service(){
            Server server;

            public void stop() {
                this.server.stop();
            }

            public void start() {
                this.server = sf.create();
            }

            public String getURL() {
                return finalURL;
            }
        };
    }
}

