/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl11;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.ow2.easywsdl.wsdl.util.CustomPrefixMapper;
import org.ow2.easywsdl.wsdl.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLWriterImpl
implements WSDLWriter {
    private DocumentBuilderFactory builder = null;

    public WSDLWriterImpl() throws WSDLException {
        WSDLJAXBContext.getInstance();
        this.builder = DocumentBuilderFactory.newInstance();
        this.builder.setNamespaceAware(true);
    }

    public WSDLWriterImpl(List<Class> addedObjectFactories) throws WSDLException {
        WSDLJAXBContext.getInstance().addOtherObjectFactory(addedObjectFactories);
        this.builder = DocumentBuilderFactory.newInstance();
        this.builder.setNamespaceAware(true);
    }

    @Override
    public void useCustomNamespacesPrefixes(String[] customPrefixes) throws WSDLException {
        new CustomPrefixMapper(customPrefixes);
    }

    @Override
    public void useNormalizedNamespacesPrefixes() throws WSDLException {
        new CustomPrefixMapper();
    }

    public Document convertWSDL11Definition2DOMElement(TDefinitions wsdlDescriptor, String schemaLocation) throws WSDLException {
        Document doc = null;
        try {
            doc = this.builder.newDocumentBuilder().newDocument();
            JAXBElement element = new JAXBElement(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"), wsdlDescriptor.getClass(), (Object)wsdlDescriptor);
            Marshaller marshaller = WSDLJAXBContext.getInstance().getJaxbContext().createMarshaller();
            if (schemaLocation != null) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            }
            marshaller.marshal((Object)element, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", ex);
        }
        return doc;
    }

    public String convertWSDL11Definition2String(TDefinitions wsdlDescriptor, String schemaLocation) throws WSDLException {
        try {
            StringWriter stringWriter = new StringWriter();
            JAXBElement element = new JAXBElement(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"), wsdlDescriptor.getClass(), (Object)wsdlDescriptor);
            Marshaller marshaller = WSDLJAXBContext.getInstance().getJaxbContext().createMarshaller();
            if (schemaLocation != null) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            }
            marshaller.marshal((Object)element, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new WSDLException("Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    @Override
    public Document getDocument(Description wsdlDef) throws WSDLException {
        Document doc = null;
        if (wsdlDef != null && wsdlDef instanceof DescriptionImpl) {
            try {
                String schemaLocation = Util.convertSchemaLocationIntoString(wsdlDef);
                doc = this.convertWSDL11Definition2DOMElement((TDefinitions)((DescriptionImpl)wsdlDef).getModel(), schemaLocation);
                if (wsdlDef.getDocumentBaseURI() != null) {
                    doc.setDocumentURI(wsdlDef.getDocumentBaseURI().toString());
                } else {
                    doc.setDocumentURI(".");
                }
            }
            catch (WSDLException e) {
                throw new WSDLException("Can not write wsdl description", e);
            }
        }
        return doc;
    }

    @Override
    public boolean getFeature(String name) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    @Override
    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    @Override
    public String writeWSDL(Description wsdlDef) throws WSDLException {
        String res = null;
        if (wsdlDef != null && wsdlDef instanceof DescriptionImpl) {
            try {
                String schemaLocation = Util.convertSchemaLocationIntoString(wsdlDef);
                res = this.convertWSDL11Definition2String((TDefinitions)((DescriptionImpl)wsdlDef).getModel(), schemaLocation);
            }
            catch (WSDLException e) {
                throw new WSDLException("Can not write wsdl description", e);
            }
        }
        return res;
    }
}

