/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl20;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractBindingImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.impl.wsdl20.BindingOperationImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl20.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl20.DocumentationImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLReaderImpl;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.BindingOperationType;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.BindingType;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.DescriptionType;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.ObjectFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingImpl
extends AbstractBindingImpl<BindingType, InterfaceType, BindingOperation>
implements Binding {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BindingImpl.class.getName());
    private ObjectFactory factory = new ObjectFactory();

    public BindingImpl(BindingType binding, DescriptionImpl desc) {
        super(binding, desc);
        this.desc = desc;
        this.documentation = new DocumentationImpl(((BindingType)this.model).getDocumentation(), (AbstractWSDLElementImpl)this);
        QName itfName = ((BindingType)this.model).getInterface();
        this.itf = (InterfaceType)this.desc.getInterface(itfName);
        for (Object element : ((BindingType)this.model).getOperationOrFaultOrAny()) {
            Object part;
            if (!(element instanceof JAXBElement) || !((part = ((JAXBElement)element).getValue()) instanceof BindingOperationType)) continue;
            BindingOperationImpl bo = new BindingOperationImpl((BindingOperationType)part, this);
            this.bindingOperations.add(bo);
        }
    }

    @Override
    public void addBindingOperation(BindingOperation bindingOperation) {
        JAXBElement<BindingOperationType> bo = this.factory.createBindingTypeOperation((BindingOperationType)((AbstractWSDLElementImpl)((Object)bindingOperation)).getModel());
        super.addBindingOperation(bindingOperation);
        ((BindingType)this.model).getOperationOrFaultOrAny().add(bo);
    }

    @Override
    public QName getQName() {
        return new QName(this.desc.getTargetNamespace(), ((BindingType)this.model).getName());
    }

    @Override
    public BindingOperation removeBindingOperation(String name) {
        throw new NotImplementedException();
    }

    @Override
    public void setInterface(InterfaceType interfaceType) {
        ((BindingType)this.model).setInterface(interfaceType.getQName());
        this.itf = interfaceType;
    }

    @Override
    public void setQName(QName name) {
        ((BindingType)this.model).setName(name.getLocalPart());
    }

    @Override
    public String getTransportProtocol() {
        String protocol = null;
        for (Map.Entry<QName, String> attribute : ((BindingType)this.model).getOtherAttributes().entrySet()) {
            if (attribute.getKey().getLocalPart().equals("protocol") && attribute.getKey().getNamespaceURI().equals(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString())) {
                protocol = attribute.getValue();
                break;
            }
            if (!attribute.getKey().getLocalPart().equals("method") && !attribute.getKey().getLocalPart().equals("methodDefault") || !attribute.getKey().getNamespaceURI().equals(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString())) continue;
            protocol = attribute.getValue();
            break;
        }
        return protocol;
    }

    @Override
    public void setTransportProtocol(String transportProtocol) throws WSDLException {
        if (transportProtocol.contains("soap")) {
            ((BindingType)this.model).setType(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString());
            ((BindingType)this.model).getOtherAttributes().put(new QName(((BindingType)this.model).getType(), "protocol"), transportProtocol);
        } else if (transportProtocol.contains("http")) {
            ((BindingType)this.model).setType(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString());
            ((BindingType)this.model).getOtherAttributes().put(new QName(((BindingType)this.model).getType(), "methodDefault"), transportProtocol);
        } else {
            throw new WSDLException("unrecognized transport protocol");
        }
    }

    @Override
    public AbsItfBinding.StyleConstant getStyle() {
        return AbsItfBinding.StyleConstant.DOCUMENT;
    }

    @Override
    public AbsItfBinding.BindingConstants getTypeOfBinding() {
        AbsItfBinding.BindingConstants res = null;
        try {
            if (((BindingType)this.model).getType() != null) {
                res = AbsItfBinding.BindingConstants.valueOf(new URI(((BindingType)this.model).getType()));
            }
        }
        catch (URISyntaxException e) {
            log.warning("The binding type is unknown");
        }
        return res;
    }

    @Override
    public String getVersion() {
        String res = null;
        res = ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "version"));
        if (res == null) {
            res = ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString(), "version"));
        }
        return res;
    }

    @Override
    public String getHttpContentEncodingDefault() {
        return ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "contentEncodingDefault"));
    }

    @Override
    public String getHttpDefaultMethod() {
        return ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "methodDefault"));
    }

    @Override
    public String getHttpQueryParameterSeparatorDefault() {
        return ((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "queryParameterSeparatorDefault"));
    }

    @Override
    public boolean isHttpCookies() {
        return Boolean.valueOf(((BindingType)this.model).getOtherAttributes().get(new QName(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString(), "cookies")));
    }

    @Override
    public List<Element> getOtherElements() throws XmlException {
        List<Element> res = super.getOtherElements();
        for (Object item : ((BindingType)this.model).getOperationOrFaultOrAny()) {
            if (!(item instanceof Element)) continue;
            res.add((Element)item);
        }
        return res;
    }

    @Override
    public BindingOperation createBindingOperation() {
        return new BindingOperationImpl(new BindingOperationType(), this);
    }

    public static BindingType replaceDOMElementByBindingType(WSDLElement parent, Element childToReplace, WSDLReaderImpl reader) throws WSDLException {
        BindingType res = null;
        try {
            if (childToReplace != null && childToReplace.getLocalName().equals("binding") && childToReplace.getNamespaceURI().equals("http://www.w3.org/ns/wsdl")) {
                Unmarshaller unmarshaller = WSDLJAXBContext.getInstance().getJaxbContext().createUnmarshaller();
                JAXBElement jaxbElement = unmarshaller.unmarshal((Node)childToReplace, BindingType.class);
                ((DescriptionType)((AbstractWSDLElementImpl)parent).getModel()).getImportOrIncludeOrTypes().remove(childToReplace);
                ((DescriptionType)((AbstractWSDLElementImpl)parent).getModel()).getImportOrIncludeOrTypes().add(jaxbElement.getValue());
                res = (BindingType)jaxbElement.getValue();
            }
        }
        catch (JAXBException e) {
            throw new WSDLException(e);
        }
        return res;
    }
}

