/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.component.wsnpoller;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.petalslink.dsb.component.wsnpoller.Component;
import org.petalslink.dsb.component.wsnpoller.ServiceInvokeToWSNJob;
import org.petalslink.dsb.service.poller.api.Job;
import org.petalslink.dsb.service.poller.api.PollerException;
import org.petalslink.dsb.service.poller.api.PollerService;
import org.petalslink.dsb.service.poller.api.PollingContext;
import org.petalslink.dsb.service.poller.api.PollingTransport;
import org.petalslink.dsb.service.poller.api.ServiceInformation;
import org.w3c.dom.Document;

public class SUManager
extends AbstractServiceUnitManager {
    private PollingTransport transport;
    private Map<String, Jbi> cache;
    private Map<String, List<PollingContext>> contexts;
    private Map<String, List<PollerService>> services;
    private Component pollerComponent;

    public SUManager(Component component) {
        super(component);
        this.pollerComponent = component;
        this.transport = component;
        this.cache = new HashMap<String, Jbi>();
        this.contexts = new HashMap<String, List<PollingContext>>();
        this.services = new HashMap<String, List<PollerService>>();
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        this.cache.put(serviceUnitName, jbiDescriptor);
        List consumes = jbiDescriptor.getServices().getConsumes();
        ArrayList<PollingContext> contexts = new ArrayList<PollingContext>();
        for (Consumes consume : consumes) {
            contexts.add(this.createContext(consume, suRootPath));
        }
        this.contexts.put(serviceUnitName, contexts);
    }

    private PollingContext createContext(Consumes consume, String suRootPath) {
        PollingContext context = null;
        ServiceUnitDataHandler dh = this.getSUDataHandlerForConsumes(consume);
        if (dh != null) {
            ConfigurationExtensions extensions = dh.getConfigurationExtensions(consume);
            String cron = extensions.get((Object)"cron");
            ServiceInformation responseTo = new ServiceInformation();
            responseTo.endpoint = extensions.get((Object)"endpoint");
            responseTo.itf = extensions.get((Object)"interface") != null ? QName.valueOf(extensions.get((Object)"interface")) : null;
            responseTo.operation = extensions.get((Object)"operation") != null ? QName.valueOf(extensions.get((Object)"operation")) : null;
            responseTo.service = extensions.get((Object)"service") != null ? QName.valueOf(extensions.get((Object)"service")) : null;
            responseTo.service = extensions.get((Object)"service") != null ? QName.valueOf(extensions.get((Object)"service")) : null;
            ServiceInformation toPoll = new ServiceInformation();
            toPoll.endpoint = consume.getEndpointName();
            toPoll.itf = consume.getInterfaceName();
            toPoll.service = consume.getServiceName();
            toPoll.operation = consume.getOperation();
            context = new PollingContext();
            context.setCron(cron);
            context.setInputMessage(this.createInputMessage(new File(suRootPath, extensions.get((Object)"inputFile"))));
            context.setJob((Job)new ServiceInvokeToWSNJob());
            context.setResponseTo(responseTo);
            context.setToPoll(toPoll);
            context.setTransport(this.transport);
            context.getExtensions().put("topicName", extensions.get((Object)"topicName"));
            context.getExtensions().put("topicURI", extensions.get((Object)"topicURI"));
            context.getExtensions().put("topicPrefix", extensions.get((Object)"topicPrefix"));
        }
        return context;
    }

    private Document createInputMessage(File f) {
        Document result = null;
        if (f != null && f.isFile()) {
            try {
                result = XMLUtil.loadDocument(new FileInputStream(f));
            }
            catch (Exception e) {
                this.logger.warning(e.getMessage());
            }
        } else {
            this.logger.warning("Can not load a document from an unknow file : " + f);
        }
        return result;
    }

    protected void doInit(String serviceUnitName, String suRootPath) throws PEtALSCDKException {
        List<PollingContext> contexts = this.contexts.get(serviceUnitName);
        if (contexts == null || contexts.size() == 0) {
            return;
        }
        ArrayList<PollerService> services = new ArrayList<PollerService>();
        for (PollingContext pollingContext : contexts) {
            try {
                services.add(this.pollerComponent.getPollingManager().getPollerService(pollingContext));
            }
            catch (PollerException e) {
                throw new PEtALSCDKException("Problem while creating poller service", (Throwable)e);
            }
        }
        this.services.put(serviceUnitName, services);
    }

    protected void doShutdown(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
        List<PollerService> services = this.services.get(serviceUnitName);
        for (PollerService service : services) {
            try {
                service.start();
            }
            catch (PollerException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
        List<PollerService> services = this.services.get(serviceUnitName);
        for (PollerService service : services) {
            try {
                service.stop();
            }
            catch (PollerException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        this.contexts.remove(serviceUnitName);
        this.services.remove(serviceUnitName);
    }
}

