/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.component.wsnpoller;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.notification.commons.NotificationHelper;
import org.petalslink.dsb.service.poller.api.Job;
import org.petalslink.dsb.service.poller.api.PollerException;
import org.petalslink.dsb.service.poller.api.PollingContext;
import org.petalslink.dsb.service.poller.api.PollingTransport;
import org.petalslink.dsb.service.poller.api.ServiceInformation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceInvokeToWSNJob
implements Job {
    final Log logger = LogFactory.getLog(ServiceInvokeToWSNJob.class);

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
    }

    public void invoke(PollingContext context) throws PollerException {
        block16: {
            PollingTransport transport;
            ServiceInformation serviceInformation;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"In invoke Job");
            }
            if ((serviceInformation = context.getToPoll()) == null) {
                throw new PollerException("Can not find the service to poll from context");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking the remote Service located at : " + serviceInformation));
            }
            if ((transport = context.getTransport()) == null) {
                throw new PollerException("Can not find a message transport in the context");
            }
            Document result = transport.send(context.getInputMessage(), serviceInformation);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Got a response from the polled service : (TODO) " + result));
            }
            if (result != null && context.getResponseTo() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending response to " + context.getResponseTo()));
                }
                String producerAddress = "dsb://wsnpoller";
                String topicLocalPart = (String)context.getExtensions().get("topicName");
                String topicURI = (String)context.getExtensions().get("topicURI");
                String topicPrefix = (String)context.getExtensions().get("topicPrefix");
                QName finalTopic = new QName(topicURI, topicLocalPart, topicPrefix);
                try {
                    Notify n = NotificationHelper.createNotification((String)producerAddress, null, null, (QName)finalTopic, (String)"http://www.w3.org/TR/1999/REC-xpath-19991116", (Document)result);
                    Document doc = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(n);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Going to send : ");
                        try {
                            this.logger.debug((Object)XMLHelper.createStringFromDOMDocument((Node)doc));
                        }
                        catch (TransformerException e) {
                            e.printStackTrace();
                        }
                    }
                    transport.fireAndForget(doc, context.getResponseTo());
                }
                catch (Exception e) {
                    if (this.logger.isWarnEnabled()) {
                        e.printStackTrace();
                    }
                    break block16;
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Message not forwarded...");
            }
            if (result == null) {
                this.logger.info((Object)"No response from the polled service");
            }
            if (context.getResponseTo() == null) {
                this.logger.info((Object)"No service defined to send the response to");
            }
        }
    }
}

