/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.ow2.petals.component.framework.api.util.IdUtil;

public class IdUtilImpl
implements IdUtil {
    private static final int RANDOM_VALUE_SIZE = 18;
    private static final String UUID_NAMESPACE = "petals:uid:";
    private final String prefix;
    private final int UUID_SIZE = "petals:uid:".length() + 18 + String.valueOf(System.nanoTime()).length() + Long.toString(Long.MAX_VALUE).length();
    private long value;
    private final Object valueLock;

    public IdUtilImpl() {
        byte[] array;
        String sid;
        Random myRand = new Random();
        long rand = myRand.nextLong();
        try {
            sid = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            sid = Thread.currentThread().getName();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(sid);
        sb.append(":");
        sb.append(Long.toString(rand));
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(sb.toString().getBytes());
            array = md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            array = sb.toString().getBytes();
        }
        StringBuffer sb2 = new StringBuffer();
        for (int j = 0; j < array.length; ++j) {
            int b = array[j] & 0xFF;
            sb2.append(Integer.toHexString(b));
        }
        int begin = myRand.nextInt();
        if (begin < 0) {
            begin *= -1;
        }
        this.value = 0L;
        this.valueLock = new Object();
        this.prefix = UUID_NAMESPACE + sb2.toString().substring(begin %= 8, begin + 18).toUpperCase();
    }

    public String createId() {
        return this.createId(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String createId(boolean prefixed) {
        long tmp;
        Object object = this.valueLock;
        synchronized (object) {
            tmp = ++this.value;
            if (tmp >= Long.MAX_VALUE) {
                this.value = 0L;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(this.UUID_SIZE);
        if (prefixed) {
            stringBuilder.append(this.prefix);
        }
        return stringBuilder.append(System.nanoTime()).append(tmp).toString();
    }
}

