/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class WsstarCommonUtils {
    private static Logger logger = Logger.getLogger(WsstarCommonUtils.class.getSimpleName());
    private static String transformerFactoryClass = "";
    private static final ThreadLocal<TransformerFactory> TRANSFORMER_FACTORY_THREAD_LOCAL = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            try {
                if (System.getProperty("java.vendor").indexOf("Sun") != -1) {
                    transformerFactoryClass = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
                } else if (System.getProperty("java.vendor").indexOf("IBM") != -1) {
                    transformerFactoryClass = "org.apache.xalan.processor.TransformerFactoryImpl";
                }
                Thread.currentThread().getContextClassLoader().loadClass(transformerFactoryClass);
                System.setProperty("javax.xml.transform.TransformerFactory", transformerFactoryClass);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, "Warning. TransformerFactory '" + transformerFactoryClass + "' not found, the standard TransformerFactory will be used.");
            }
            return TransformerFactory.newInstance();
        }
    };
    private static final ThreadLocal<Transformer> DEFAULT_TRANSFORMER_THREAD_LOCAL = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> JVM_DOCUMENT_BUILDER_THREAD_LOCAL = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                Thread.currentThread().setContextClassLoader(systemClassLoader);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                return documentBuilder;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> NAMESPACE_DOCUMENT_BUILDER_THREAD_LOCAL = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                return documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> DEFAULT_DOCUMENT_BUILDER_THREAD_LOCAL = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                return documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }
    };

    private WsstarCommonUtils() {
    }

    public static Document convertFromFiletoDocument(File file) throws Exception {
        Document result = null;
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            dbfac.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            result = docBuilder.parse(file);
        }
        catch (SAXException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e);
        }
        return result;
    }

    public static String prettyPrint(Document xmlDocument, String encoding) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            WsstarCommonUtils.prettify(xmlDocument, outStream, encoding);
            result = outStream.toString(encoding);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "write_dom failed:" + e);
        }
        return result;
    }

    public static String prettyPrint(Document xmlDocument) {
        return WsstarCommonUtils.prettyPrint(xmlDocument, WsstarCommonUtils.getEncoding(xmlDocument));
    }

    public static void prettify(Node node, OutputStream out, String encoding) throws TransformerException {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = WsstarCommonUtils.getStyleSheetSource();
        TransformerFactory tf = TRANSFORMER_FACTORY_THREAD_LOCAL.get();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(source, new StreamResult(out));
    }

    public static String getEncoding(Document xmlDocument) {
        String encoding = "UTF-8";
        return encoding;
    }

    private static Source getStyleSheetSource() {
        return new StreamSource(WsstarCommonUtils.class.getResourceAsStream("/util/prettyPrint.xsl"));
    }

    public static Transformer getDefaultTransformerFactoryThreadLocal() {
        return DEFAULT_TRANSFORMER_THREAD_LOCAL.get();
    }

    public static DocumentBuilder getJvmDocumentBuilder() {
        return JVM_DOCUMENT_BUILDER_THREAD_LOCAL.get();
    }

    public static DocumentBuilder getNamespaceDocumentBuilder() {
        return NAMESPACE_DOCUMENT_BUILDER_THREAD_LOCAL.get();
    }

    public static DocumentBuilder getDefaultDocumentBuilder() {
        return DEFAULT_DOCUMENT_BUILDER_THREAD_LOCAL.get();
    }
}

