/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.naming.InitialContext;
import org.ow2.petals.component.framework.ComponentInformation;
import org.ow2.petals.component.framework.JBIClient;
import org.ow2.petals.component.framework.JNDIComponentInformation;
import org.ow2.petals.component.framework.PluginAware;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.petalslink.dsb.service.client.Client;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetalsBindingComponent
extends AbstractBindingComponent
implements PluginAware {
    private final Map<Class<?>, Object> plugins = new ConcurrentHashMap();
    private final Properties containerProperties = new Properties();
    private Client client;

    @Override
    protected final void doInit() throws JBIException {
        JNDIComponentInformation componentInformation = new JNDIComponentInformation(){

            public InitialContext getInitialContext() {
                return PetalsBindingComponent.this.getContext().getNamingContext();
            }

            protected String getComponentName() {
                return PetalsBindingComponent.this.getContext().getComponentName();
            }
        };
        this.addPlugin(ComponentInformation.class, componentInformation);
        this.getLogger().fine("Loading the container properties...");
        try {
            this.containerProperties.load(PetalsBindingComponent.class.getClassLoader().getResourceAsStream("components.properties"));
        }
        catch (Exception e) {
            this.getLogger().warning("Can not find the components properties file provided by the container");
        }
        this.postDoInit();
    }

    protected void postDoInit() throws JBIException {
    }

    @Override
    public <T> void addPlugin(Class<T> type, T plugin) {
        if (type == null || plugin == null) {
            return;
        }
        this.plugins.put(type, plugin);
    }

    @Override
    public <T> T getPlugin(Class<T> type) {
        Object o = this.plugins.get(type);
        if (o != null) {
            return type.cast(o);
        }
        return null;
    }

    public String getContainerConfiguration(String propertyName) {
        String finalPropertyName = this.getContext().getComponentName() + "." + propertyName;
        return this.containerProperties.getProperty(finalPropertyName);
    }

    public synchronized Client getJBIClient() {
        if (this.client == null) {
            this.client = new JBIClient(this.context);
        }
        return this.client;
    }
}

