/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.topics.datatypes.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class WstopConstants {
    public static final String WS_TOPICS_NAMESPACE_URI = "http://docs.oasis-open.org/wsn/t-1";
    public static final String WS_TOPICS_PREFIX = "wstop";
    public static final QName TOPIC_SET_QNAME = new QName("http://docs.oasis-open.org/wsn/t-1", "TopicSet", "wstop");
    public static final QName TOPIC_NAMESPACE_QNAME = new QName("http://docs.oasis-open.org/wsn/t-1", "TopicNamespace", "wstop");
    public static final QName TOPIC_QNAME = new QName("http://docs.oasis-open.org/wsn/t-1", "Topic", "wstop");
    public static final QName MESSAGE_PATTERN_QNAME = new QName("http://docs.oasis-open.org/wsn/t-1", "MessagePattern", "wstop");
    private static final String ERROR_URI = "The string value used to build java.net.URI Object does not respect the URI Syntax (according to RFC-2396/RFC-2732)";
    private static URI simpleUri;
    public static final URI SIMPLE_TOPIC_EXPRESSION_DIALECT_URI;
    private static URI concreteUri;
    public static final URI CONCRETE_TOPIC_EXPRESSION_DIALECT_URI;
    private static URI fullUri;
    public static final URI FULL_TOPIC_EXPRESSION_DIALECT_URI;
    private static URI xpathUri;
    public static final URI XPATH_TOPIC_EXPRESSION_DIALECT_URI;
    public static final char SEPARATOR_CHILD_OF = '/';
    public static final String SEPARATOR_SUB_TREE_OF = "//";
    public static final char STAR_WILDCARD = '*';
    public static final char POINT_WILDCARD = '.';

    static {
        SIMPLE_TOPIC_EXPRESSION_DIALECT_URI = simpleUri != null ? simpleUri : WstopConstants.initSimpleDialectURI();
        CONCRETE_TOPIC_EXPRESSION_DIALECT_URI = concreteUri != null ? concreteUri : WstopConstants.initConcreteDialectURI();
        FULL_TOPIC_EXPRESSION_DIALECT_URI = fullUri != null ? fullUri : WstopConstants.initFullDialectURI();
        XPATH_TOPIC_EXPRESSION_DIALECT_URI = xpathUri != null ? xpathUri : WstopConstants.initXpathDialectURI();
    }

    protected WstopConstants() {
        throw new UnsupportedOperationException();
    }

    private static URI initSimpleDialectURI() {
        try {
            simpleUri = new URI("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple");
        }
        catch (URISyntaxException e) {
            Logger.getLogger(WstopConstants.class.getSimpleName()).log(Level.WARNING, ERROR_URI, e);
        }
        return simpleUri;
    }

    private static URI initConcreteDialectURI() {
        try {
            concreteUri = new URI("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
        }
        catch (URISyntaxException e) {
            Logger.getLogger(WstopConstants.class.getSimpleName()).log(Level.WARNING, ERROR_URI, e);
        }
        return concreteUri;
    }

    private static URI initFullDialectURI() {
        try {
            fullUri = new URI("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        }
        catch (URISyntaxException e) {
            Logger.getLogger(WstopConstants.class.getSimpleName()).log(Level.WARNING, ERROR_URI, e);
        }
        return fullUri;
    }

    private static URI initXpathDialectURI() {
        try {
            xpathUri = new URI("http://www.w3.org/TR/1999/REC-xpath-19991116");
        }
        catch (URISyntaxException e) {
            Logger.getLogger(WstopConstants.class.getSimpleName()).log(Level.WARNING, ERROR_URI, e);
        }
        return xpathUri;
    }
}

