/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class OSGiAutomaticWorkQueue
extends AutomaticWorkQueueImpl {
    final WorkQueueList qlist;

    public OSGiAutomaticWorkQueue(String name, WorkQueueList ql) {
        super(name);
        this.qlist = ql;
    }

    public void setHighWaterMark(int hwm) {
        super.setHighWaterMark(hwm);
        this.qlist.updateProperty("org.apache.cxf.workqueue." + this.getName() + ".highWaterMark", Integer.toString(this.getHighWaterMark()));
    }

    public void setLowWaterMark(int lwm) {
        super.setLowWaterMark(lwm);
        this.qlist.updateProperty("org.apache.cxf.workqueue." + this.getName() + ".lowWaterMark", Integer.toString(this.getLowWaterMark()));
    }

    public void setInitialSize(int initialSize) {
        super.setInitialSize(initialSize);
        this.qlist.updateProperty("org.apache.cxf.workqueue." + this.getName() + ".initialSize", Integer.toString(initialSize));
    }

    public void setQueueSize(int size) {
        super.setQueueSize(size);
        this.qlist.updateProperty("org.apache.cxf.workqueue." + this.getName() + ".queueSize", Integer.toString(size));
    }

    public void setDequeueTimeout(long l) {
        super.setDequeueTimeout(l);
        this.qlist.updateProperty("org.apache.cxf.workqueue." + this.getName() + ".dequeueTimeout", Long.toString(l));
    }

    public void updated(Dictionary d) throws ConfigurationException {
        String name = this.getName();
        String s = (String)d.get("org.apache.cxf.workqueue." + name + ".highWaterMark");
        if (s != null) {
            super.setHighWaterMark(Integer.parseInt(s));
        }
        if ((s = (String)d.get("org.apache.cxf.workqueue." + name + ".lowWaterMark")) != null) {
            super.setLowWaterMark(Integer.parseInt(s));
        }
        if ((s = (String)d.get("org.apache.cxf.workqueue." + name + ".initialSize")) != null) {
            super.setInitialSize(Integer.parseInt(s));
        }
        if ((s = (String)d.get("org.apache.cxf.workqueue." + name + ".dequeueTimeout")) != null) {
            super.setDequeueTimeout(Long.parseLong(s));
        }
        if ((s = (String)d.get("org.apache.cxf.workqueue." + name + ".queueSize")) != null) {
            super.setQueueSize(Integer.parseInt(s));
        }
    }

    static class WorkQueueList
    implements ManagedService {
        Map<String, OSGiAutomaticWorkQueue> queues = new ConcurrentHashMap<String, OSGiAutomaticWorkQueue>();
        ServiceRegistration registration;
        Configuration config;
        Properties current = new Properties();

        WorkQueueList() {
        }

        public synchronized void register(BundleContext ctx, Configuration c) {
            Properties props = new Properties();
            props.put("service.pid", "org.apache.cxf.workqueues");
            this.registration = ctx.registerService(ManagedService.class.getName(), (Object)this, (Dictionary)props);
            this.config = c;
        }

        public synchronized void updateProperty(String key, String val) {
            if (val != null) {
                this.current.put(key, val);
            } else {
                this.current.remove(key);
            }
            try {
                this.config.update((Dictionary)this.current);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized void updated(Dictionary d) throws ConfigurationException {
            this.current.clear();
            if (d == null) {
                return;
            }
            Enumeration e = d.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                this.current.put(k, d.get(k));
            }
            String s = (String)d.get("org.apache.cxf.workqueue.names");
            if (s != null) {
                String[] s2;
                for (String name : s2 = s.split(",")) {
                    if (this.queues.containsKey(name = name.trim())) {
                        this.queues.get(name).updated(d);
                        continue;
                    }
                    OSGiAutomaticWorkQueue wq = new OSGiAutomaticWorkQueue(name, this);
                    wq.updated(d);
                    wq.setShared(true);
                    this.queues.put(name, wq);
                }
            }
            if (this.registration != null) {
                this.registration.setProperties(d);
            }
        }
    }
}

