/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.service.poller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.petalslink.dsb.service.poller.api.Job;
import org.petalslink.dsb.service.poller.api.PollerException;
import org.petalslink.dsb.service.poller.api.PollingContext;
import org.petalslink.dsb.service.poller.api.PollingTransport;
import org.petalslink.dsb.service.poller.api.ServiceInformation;
import org.w3c.dom.Document;

public class ServiceInvokeJob
implements Job {
    final Log logger = LogFactory.getLog(ServiceInvokeJob.class);

    public void invoke(PollingContext context) throws PollerException {
        PollingTransport transport;
        ServiceInformation serviceInformation;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In invoke Job");
        }
        if ((serviceInformation = context.getToPoll()) == null) {
            throw new PollerException("Can not find the service to poll from context");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Invoking the remote Service located at : " + serviceInformation);
        }
        if ((transport = context.getTransport()) == null) {
            throw new PollerException("Can not find a message transport in the context");
        }
        Document result = transport.send(context.getInputMessage(), serviceInformation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got a response from the polled service : (TODO) " + result);
        }
        if (result != null && context.getResponseTo() != null) {
            transport.send(result, context.getResponseTo());
        } else {
            if (result == null) {
                this.logger.info("No response from the polled service");
            }
            if (context.getResponseTo() == null) {
                this.logger.info("No service defined to send the response to");
            }
        }
    }
}

