/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.topic;

import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.topics.WstopConstants;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnExtensionConstants;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.TopicExpressionDialectUnknownFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.TopicNotSupportedFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstConstants;
import com.ebmwebsourcing.wsstar.notification.service.topic.XPathAnalyzer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.util.XMLPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WstopTopicManager {
    private final List<String> supportedDialectsForSetOfTopics = Collections.synchronizedList(new ArrayList());
    private Document supportedTopics = null;
    private Logger logger = null;
    private final XPathAnalyzer xpathAnalyser;

    public WstopTopicManager(InputStream supportedTopicSetConfig) {
        this.supportedDialectsForSetOfTopics.add("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        this.supportedDialectsForSetOfTopics.add("http://www.w3.org/TR/1999/REC-xpath-19991116");
        this.logger = Logger.getLogger(WstopTopicManager.class.getName());
        this.xpathAnalyser = new XPathAnalyzer();
        try {
            this.supportedTopics = WstopTopicManager.convertFromStreamToJDocument(supportedTopicSetConfig);
        }
        catch (JDOMException e) {
            this.logger.log(Level.WARNING, "There is a problem with your configuration file of \"supported TopicSet\". (does it  well formatted?)", e);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "There is a problem with your configuration file of \"supported TopicSet\". (does it  well formatted?)", e);
        }
    }

    public WstopTopicManager(InputStream topicNamespaceStream, List<String> supportedTopics) throws WSNotificationException {
        this.supportedDialectsForSetOfTopics.add("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        this.supportedDialectsForSetOfTopics.add("http://www.w3.org/TR/1999/REC-xpath-19991116");
        this.logger = Logger.getLogger(WstopTopicManager.class.getName());
        this.xpathAnalyser = new XPathAnalyzer();
        try {
            ByteArrayInputStream supportedTopicSetConfig = null;
            if (topicNamespaceStream != null) {
                Document jdom = WstopTopicManager.convertFromStreamToJDocument(topicNamespaceStream);
                org.w3c.dom.Document domDocument = null;
                DOMOutputter converter = new DOMOutputter();
                domDocument = converter.output(jdom);
                TopicNamespaceType topicNamespace = WSNotificationReader.getInstance().readTopicNamespaceType(domDocument);
                TopicSetType topicSet = this.createTopicSetFromTopicNamespace(topicNamespace, supportedTopics);
                org.w3c.dom.Document topicSetDom = WSNotificationWriter.getInstance().writeTopicSetType(topicSet);
                supportedTopicSetConfig = new ByteArrayInputStream(XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)topicSetDom).getBytes());
                this.supportedTopics = WstopTopicManager.convertFromStreamToJDocument(supportedTopicSetConfig);
            }
        }
        catch (JDOMException e1) {
            throw new WSNotificationException(e1);
        }
        catch (IOException e1) {
            throw new WSNotificationException(e1);
        }
    }

    private static Document convertFromStreamToJDocument(InputStream supportedTopicsConfig) throws JDOMException, IOException {
        Document result = null;
        SAXBuilder builder = new SAXBuilder();
        result = builder.build(supportedTopicsConfig);
        return result;
    }

    private String displayCurrentSupportedTopicList() {
        String log = "\n ~~~ Supported Topics List (with stored registration/subscription uuids): ~~~ \n";
        try {
            DOMOutputter output = new DOMOutputter();
            org.w3c.dom.Document dom = output.output(this.supportedTopics);
            log = log + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)dom);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        log = log + "\n \t\t ~~~~~~ \n";
        return log;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addSupportedDialect(String dialactURI) {
        this.supportedDialectsForSetOfTopics.add(dialactURI);
    }

    public List<String> getSupportedDialectForSetOfTopics() {
        return this.supportedDialectsForSetOfTopics;
    }

    public Document getSupportedTopics() {
        return this.supportedTopics;
    }

    public void RAZSupportedTopicSet(InputStream defaultConfig) {
        try {
            this.supportedTopics = WstopTopicManager.convertFromStreamToJDocument(defaultConfig);
        }
        catch (JDOMException e) {
            this.logger.log(Level.WARNING, "There is a problem with your configuration file of \"supported TopicSet\". (does it  well formatted?)", e);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "There is a problem with your configuration file of \"supported TopicSet\". (does it  well formatted?)", e);
        }
    }

    private boolean isValideDialect(String topicExpressionDialect) {
        boolean result = false;
        for (String knownDialect : this.supportedDialectsForSetOfTopics) {
            result |= topicExpressionDialect.compareTo(knownDialect) == 0;
        }
        return result;
    }

    public boolean acceptSubscribeOrRegisterTopicExpression(TopicExpressionType topicExprToCheck, boolean isSubscribeRequest) throws WSNotificationException, WSNotificationFault {
        String faultMsg;
        boolean result = true;
        String string = faultMsg = isSubscribeRequest ? "The Subscribe message contained a TopicExpression filter having a dialect that was not understood or supported by the NotificationProducer." : "The RegisterPublisher message contained a TopicExpression having a dialect that was not understood or supported by the NotificationBroker.";
        if (!this.isValideDialect(topicExprToCheck.getDialect())) {
            throw new TopicExpressionDialectUnknownFault("eng", faultMsg);
        }
        String topicExprStringForm = topicExprToCheck.getContent();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        String formattedTopicExpression = "";
        for (QName ns : topicExprToCheck.getTopicNameSpace()) {
            context.addNamespace(ns.getLocalPart(), ns.getNamespaceURI());
        }
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(topicExprStringForm, this.supportedTopics.getRootElement(), context);
        result = res != null && res.size() > 0;
        return result;
    }

    public void storeNewRegistration(TopicExpressionType topicExprToCheck, String registrationId) throws WSNotificationException, WSNotificationFault {
        boolean resourceStored = false;
        String faultMsg = "The RegisterPublisher message contained a TopicExpression having a dialect that was not understood or supported by the NotificationBroker.";
        if (!this.isValideDialect(topicExprToCheck.getDialect())) {
            throw new TopicExpressionDialectUnknownFault("eng", "The RegisterPublisher message contained a TopicExpression having a dialect that was not understood or supported by the NotificationBroker.");
        }
        String topicExprStringForm = topicExprToCheck.getContent();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        String formattedTopicExpression = "";
        for (QName ns : topicExprToCheck.getTopicNameSpace()) {
            context.addNamespace(ns.getLocalPart(), ns.getNamespaceURI());
        }
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(topicExprStringForm, this.supportedTopics.getRootElement(), context);
        if (res != null && res.size() > 0) {
            Element currentResId = null;
            for (Object topicNodeItem : res) {
                currentResId = ((Element)topicNodeItem).getChild(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
                if (currentResId == null) {
                    currentResId = new Element(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
                    ((Element)topicNodeItem).addContent((Content)currentResId);
                }
                currentResId.getChildren().add(new Element(WsnExtensionConstants.REGISTRATION_ID_QNAME.getLocalPart(), "ebm", WsnExtensionConstants.REGISTRATION_ID_QNAME.getNamespaceURI()).setText(registrationId));
                resourceStored = true;
            }
        }
        if (!resourceStored) {
            throw new TopicNotSupportedFault("eng", "The TopicExpression does not match any Topic supported by the NotificationBroker.");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
    }

    public void removeExistingRegistration(String registrationId) throws WSNotificationException, WSNotificationFault {
        boolean resourceRemoved = false;
        String resourceIdsXpatExpr = "*//" + WsnExtensionConstants.RESOURCE_IDS_QNAME.getPrefix() + ":" + WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(resourceIdsXpatExpr, this.supportedTopics.getRootElement(), context);
        if (res != null && res.size() > 0) {
            String findIdXpathExpr = WsnExtensionConstants.REGISTRATION_ID_QNAME.getPrefix() + ":" + WsnExtensionConstants.REGISTRATION_ID_QNAME.getLocalPart() + "[child::text()=\"" + registrationId + "\"]";
            List<?> subRes = null;
            for (Object nodeItem : res) {
                subRes = this.xpathAnalyser.evaluate(findIdXpathExpr, (Element)nodeItem, context);
                if (subRes == null || subRes.size() <= 0) continue;
                ((Element)nodeItem).removeContent((Content)subRes.get(0));
                resourceRemoved = true;
            }
        }
        if (!resourceRemoved) {
            throw new ResourceUnknownFault("eng", "The PublisherRegistration is a WS-Resource, and the resource identified in the message is not known to the Web service.");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
    }

    public void storeNewSubscription(TopicExpressionType topicExprToCheck, String subscriptionId) throws WSNotificationException, WSNotificationFault {
        boolean resourceStored = false;
        String faultMsg = "The Subscribe message contained a TopicExpression filter having a dialect that was not understood or supported by the NotificationProducer.";
        if (!this.isValideDialect(topicExprToCheck.getDialect())) {
            throw new TopicExpressionDialectUnknownFault("eng", "The Subscribe message contained a TopicExpression filter having a dialect that was not understood or supported by the NotificationProducer.");
        }
        String topicExprStringForm = topicExprToCheck.getContent();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        String formattedTopicExpression = "";
        for (QName ns : topicExprToCheck.getTopicNameSpace()) {
            context.addNamespace(ns.getLocalPart(), ns.getNamespaceURI());
        }
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(topicExprStringForm, this.supportedTopics.getRootElement(), context);
        if (res != null && res.size() > 0) {
            Element currentResId = null;
            for (Object topicNodeItem : res) {
                currentResId = ((Element)topicNodeItem).getChild(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
                if (currentResId == null) {
                    currentResId = new Element(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
                    ((Element)topicNodeItem).addContent((Content)currentResId);
                }
                currentResId.getChildren().add(new Element(WsnExtensionConstants.SUBSCRIPTION_ID_QNAME.getLocalPart(), WsnExtensionConstants.SUBSCRIPTION_ID_QNAME.getPrefix(), WsnExtensionConstants.SUBSCRIPTION_ID_QNAME.getNamespaceURI()).setText(subscriptionId));
                resourceStored = true;
            }
        }
        if (!resourceStored) {
            throw new TopicNotSupportedFault("eng", "The Subscribe message contained a TopicExpression filter that referenced a topic that was not supported by the NotificationProducer.");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
    }

    public void removeExistingSubscription(String subscriptionId) throws WSNotificationException, WSNotificationFault {
        boolean resourceRemoved = false;
        String resourceIdsXpatExpr = "*//" + WsnExtensionConstants.RESOURCE_IDS_QNAME.getPrefix() + ":" + WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(resourceIdsXpatExpr, this.supportedTopics.getRootElement(), context);
        if (res != null && res.size() > 0) {
            String findIdXpathExpr = WsnExtensionConstants.SUBSCRIPTION_ID_QNAME.getPrefix() + ":" + WsnExtensionConstants.SUBSCRIPTION_ID_QNAME.getLocalPart() + "[child::text()=\"" + subscriptionId + "\"]";
            List<?> subRes = null;
            for (Object nodeItem : res) {
                subRes = this.xpathAnalyser.evaluate(findIdXpathExpr, (Element)nodeItem, context);
                if (subRes == null || subRes.size() <= 0) continue;
                ((Element)nodeItem).removeContent((Content)subRes.get(0));
                resourceRemoved = true;
            }
        }
        if (!resourceRemoved) {
            throw new ResourceUnknownFault("eng", "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
    }

    public void storeNotifContentUuid(TopicExpressionType topic, String currentMessageContentUuid) throws WSNotificationException, WSNotificationFault {
        boolean resourceStored = false;
        if (topic.getDialect().compareTo("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple") != 0 && topic.getDialect().compareTo("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete") != 0 && !this.isValideDialect(topic.getDialect())) {
            throw new TopicExpressionDialectUnknownFault("eng", "The Topic element of the GetCurrentMessage message had a dialect that was not understood or supported by the NotificationProducer.");
        }
        String topicExprStringForm = topic.getContent();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        String formattedTopicExpression = "";
        for (QName ns : topic.getTopicNameSpace()) {
            context.addNamespace(ns.getLocalPart(), ns.getNamespaceURI());
        }
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(topicExprStringForm, this.supportedTopics.getRootElement(), context);
        if (res != null && res.size() == 1) {
            Element currentMsgIdNode = null;
            Object topicNode = res.get(0);
            Element currentResIdNode = ((Element)topicNode).getChild(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
            if (currentResIdNode == null) {
                currentResIdNode = new Element(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
                ((Element)topicNode).addContent((Content)currentResIdNode);
            }
            if ((currentMsgIdNode = currentResIdNode.getChild(WsnExtensionConstants.CURRENT_MESSAGE_ID_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.CURRENT_MESSAGE_ID_QNAME.getNamespaceURI()))) == null) {
                currentMsgIdNode = new Element(WsnExtensionConstants.CURRENT_MESSAGE_ID_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.CURRENT_MESSAGE_ID_QNAME.getNamespaceURI()));
                currentResIdNode.addContent((Content)currentMsgIdNode);
            }
            currentMsgIdNode.setText(currentMessageContentUuid);
            resourceStored = true;
        }
        if (!resourceStored) {
            throw new TopicNotSupportedFault("eng", "The Topic element of the GetCurrentMessage message referenced a topic that was not supported by the NotificationProducer.");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
    }

    public String getNotifContentUuid(TopicExpressionType topic, Boolean isSetRequest) throws WSNotificationException, WSNotificationFault {
        String result = null;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
        if (topic.getDialect().compareTo("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple") != 0 && topic.getDialect().compareTo("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete") != 0 && !this.isValideDialect(topic.getDialect())) {
            throw new TopicExpressionDialectUnknownFault("eng", "The Topic element of the GetCurrentMessage message had a dialect that was not understood or supported by the NotificationProducer.");
        }
        String topicExprStringForm = topic.getContent();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        String formattedTopicExpression = "";
        for (QName ns : topic.getTopicNameSpace()) {
            context.addNamespace(ns.getLocalPart(), ns.getNamespaceURI());
        }
        formattedTopicExpression = topicExprStringForm;
        String topicTag = "[@wstop:topic='true']";
        if (!formattedTopicExpression.contains("[@wstop:topic='true']")) {
            formattedTopicExpression = formattedTopicExpression + "[@wstop:topic='true']";
        }
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(formattedTopicExpression, this.supportedTopics.getRootElement(), context);
        if (res != null && res.size() == 1) {
            Object topicNode = res.get(0);
            String findIdXpathExpr = WsnExtensionConstants.CURRENT_MESSAGE_ID_QNAME.getPrefix() + ":" + WsnExtensionConstants.CURRENT_MESSAGE_ID_QNAME.getLocalPart();
            Element rIdsOffoundTopic = ((Element)topicNode).getChild(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
            List<?> currentMesgUuidRes = null;
            currentMesgUuidRes = this.xpathAnalyser.evaluate(findIdXpathExpr, rIdsOffoundTopic, context);
            if (currentMesgUuidRes != null && currentMesgUuidRes.size() == 1) {
                Object currentMessageUuidNode = currentMesgUuidRes.get(0);
                result = ((Element)currentMessageUuidNode).getText();
            } else if (!isSetRequest.booleanValue()) {
                throw new TopicExpressionDialectUnknownFault("eng", "The topic referenced in the GetCurrentMessage message does not have any pending messages.");
            }
        } else {
            if (res != null && res.size() > 0) {
                throw new TopicExpressionDialectUnknownFault("eng", "The GetCurrentMessage message referenced more than one topic.");
            }
            throw new TopicExpressionDialectUnknownFault("eng", "The topic referenced in the GetCurrentMessage message does not have any pending messages.");
        }
        return result;
    }

    public List<String> getSubscriptionIdsFromTopicsSet(TopicExpressionType topic, boolean isNotification) throws WSNotificationException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
        if (isNotification && topic.getDialect().compareTo("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete") != 0 || !isNotification && !this.isValideDialect(topic.getDialect())) {
            return null;
        }
        String topicExprStringForm = topic.getContent();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        String formattedTopicExpression = "";
        for (QName ns : topic.getTopicNameSpace()) {
            context.addNamespace(ns.getLocalPart(), ns.getNamespaceURI());
        }
        formattedTopicExpression = topicExprStringForm;
        String topicTag = "[@wstop:topic='true']";
        if (!formattedTopicExpression.contains("[@wstop:topic='true']")) {
            formattedTopicExpression = formattedTopicExpression + "[@wstop:topic='true']";
        }
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(formattedTopicExpression, this.supportedTopics.getRootElement(), context);
        if (res != null) {
            for (Object item : res) {
                String findIdXpathExpr = WsnExtensionConstants.SUBSCRIPTION_ID_QNAME.getPrefix() + ":" + WsnExtensionConstants.SUBSCRIPTION_ID_QNAME.getLocalPart();
                Element rIdsOffoundTopic = ((Element)item).getChild(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
                List<?> subRes = null;
                subRes = this.xpathAnalyser.evaluate(findIdXpathExpr, rIdsOffoundTopic, context);
                if (subRes == null || subRes.size() <= 0) continue;
                for (Object susbcriptionNodeItem : subRes) {
                    String uuidToStore = ((Element)susbcriptionNodeItem).getText();
                    if (result.contains(uuidToStore)) continue;
                    result.add(uuidToStore);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    public List<String> getRegistrationIdsFromTopicsSet(TopicExpressionType topic) throws WSNotificationException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.displayCurrentSupportedTopicList());
        }
        if (!this.isValideDialect(topic.getDialect())) {
            return null;
        }
        String topicExprStringForm = topic.getContent();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        String formattedTopicExpression = "";
        for (QName ns : topic.getTopicNameSpace()) {
            context.addNamespace(ns.getLocalPart(), ns.getNamespaceURI());
        }
        formattedTopicExpression = topicExprStringForm + "[@wstop:topic='true']";
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        List<?> res = this.xpathAnalyser.evaluate(formattedTopicExpression, this.supportedTopics.getRootElement(), context);
        if (res != null) {
            for (Object item : res) {
                String findIdXpathExpr = WsnExtensionConstants.REGISTRATION_ID_QNAME.getPrefix() + ":" + WsnExtensionConstants.REGISTRATION_ID_QNAME.getLocalPart();
                Element rIdsOffoundTopic = ((Element)item).getChild(WsnExtensionConstants.RESOURCE_IDS_QNAME.getLocalPart(), Namespace.getNamespace((String)WsnExtensionConstants.RESOURCE_IDS_QNAME.getNamespaceURI()));
                List<?> subRes = null;
                subRes = this.xpathAnalyser.evaluate(findIdXpathExpr, rIdsOffoundTopic, context);
                if (subRes == null || subRes.size() <= 0) continue;
                for (Object susbcriptionNodeItem : subRes) {
                    String uuidToStore = ((Element)susbcriptionNodeItem).getText();
                    if (result.contains(uuidToStore)) continue;
                    result.add(uuidToStore);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    public List<TopicExpressionType> getTopicSetPath(String subscriptionId) throws WSNotificationException {
        ArrayList<TopicExpressionType> result = new ArrayList<TopicExpressionType>();
        NamespaceMapperImpl context = new NamespaceMapperImpl();
        context.addNamespace("wstop", "http://docs.oasis-open.org/wsn/t-1");
        context.addNamespace("ebm", "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds");
        String xpathExpression = "//*[@wstop:topic='true' and ebm:ResourceIds/ebm:SubscriptionId=\"" + subscriptionId + "\"]";
        List<?> nodeRes = this.xpathAnalyser.evaluate(xpathExpression, this.supportedTopics.getRootElement(), context);
        TopicExpressionType currentTopExpr = null;
        String currentTopExprContent = "";
        Element currentElt = null;
        if (nodeRes != null) {
            for (Object item : nodeRes) {
                currentElt = (Element)item;
                currentTopExpr = WSNotificationFactory.getInstance().createTopicExpressionType();
                currentTopExpr.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
                currentTopExprContent = currentElt.getName();
                while (currentElt.getParentElement() != null && !currentElt.getParentElement().isRootElement()) {
                    currentTopExprContent = currentElt.getParentElement().getName() + "/" + currentTopExprContent;
                    if (currentElt.getParentElement().getNamespacePrefix() != null && currentElt.getParentElement().getNamespacePrefix().length() > 0) {
                        currentTopExprContent = currentElt.getParentElement().getNamespacePrefix() + ":" + currentTopExprContent;
                        currentTopExpr.addTopicNameSpace(currentElt.getParentElement().getNamespacePrefix(), currentElt.getParentElement().getNamespace(currentElt.getParentElement().getNamespacePrefix()).getURI());
                    }
                    currentElt = currentElt.getParentElement();
                }
                currentTopExprContent = currentTopExprContent + "[@wstop:topic='true']";
                currentTopExpr.setContent(currentTopExprContent);
                result.add(currentTopExpr);
            }
        }
        return result;
    }

    public TopicSetType createTopicSetFromTopicNamespace(TopicNamespaceType topicns, List<String> topics) throws WSNotificationException {
        TopicSetType res = null;
        TopicNamespaceType topicNS = null;
        org.w3c.dom.Document domDocument = WSNotificationWriter.getInstance().writeTopicNamespaceType(topicns);
        DOMBuilder builder = new DOMBuilder();
        Document jdomDocument = builder.build(domDocument);
        this.addSupportedTopicAttr(jdomDocument.getRootElement().getChildren(), topics);
        DOMOutputter converter = new DOMOutputter();
        try {
            domDocument = converter.output(jdomDocument);
        }
        catch (JDOMException e) {
            throw new WSNotificationException(e);
        }
        topicNS = WSNotificationReader.getInstance().readTopicNamespaceType(domDocument);
        res = this.createTopicSetFromSupportedTopicNamespace(topicNS);
        return res;
    }

    private void addSupportedTopicAttr(List<Element> children, List<String> topics) {
        for (Element child : children) {
            if (!child.getName().equals(WstopConstants.TOPIC_QNAME.getLocalPart()) || !child.getNamespaceURI().equals(WstopConstants.TOPIC_QNAME.getNamespaceURI())) continue;
            if (topics.contains(child.getAttribute("name").getValue())) {
                child.setAttribute(WsnExtensionConstants.SUPPORTED_QNAME_ATTR.getLocalPart(), "true", Namespace.getNamespace((String)WsnExtensionConstants.SUPPORTED_QNAME_ATTR.getPrefix(), (String)WsnExtensionConstants.SUPPORTED_QNAME_ATTR.getNamespaceURI()));
            }
            if (child.getChildren() == null || child.getChildren().size() <= 0) continue;
            this.addSupportedTopicAttr(child.getChildren(), topics);
        }
    }

    public TopicSetType createTopicSetFromSupportedTopicNamespace(TopicNamespaceType topicns) throws WSNotificationException {
        TopicSetType res = null;
        Namespace tns = Namespace.getNamespace((String)"tns", (String)topicns.getTargetNamespace());
        Element root = this.createEmptyTopicSet();
        Document doc = new Document(root);
        this.createTopicSetTree(topicns.getTopics(), root, tns, true);
        org.w3c.dom.Document domDocument = null;
        DOMOutputter converter = new DOMOutputter();
        try {
            domDocument = converter.output(doc);
        }
        catch (JDOMException e) {
            throw new WSNotificationException(e);
        }
        res = WSNotificationReader.getInstance().readTopicSetType(domDocument);
        return res;
    }

    private Element createEmptyTopicSet() {
        Namespace wstop = Namespace.getNamespace((String)"wstop", (String)"http://docs.oasis-open.org/wsn/t-1");
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element root = new Element(WstConstants.TOPIC_SET_QNAME.getLocalPart(), wstop);
        root.addNamespaceDeclaration(xsi);
        root.setAttribute("schemaLocation", "http://docs.oasis-open.org/wsn/t-1 http://docs.oasis-open.org/wsn/t-1.xsd", xsi);
        return root;
    }

    private void createTopicSetTree(List<TopicType> topics, Element root, Namespace tns, boolean first) {
        Namespace wstop = Namespace.getNamespace((String)"wstop", (String)"http://docs.oasis-open.org/wsn/t-1");
        for (TopicType topic : topics) {
            Element childTopic = null;
            childTopic = first ? new Element(topic.getName(), tns) : new Element(topic.getName());
            if (WsnSpecificTypeHelper.isTopicSupported((TopicType)topic) != null && WsnSpecificTypeHelper.isTopicSupported((TopicType)topic).booleanValue()) {
                childTopic.setAttribute("topic", "true", wstop);
            }
            if (topic.getChildren() != null && topic.getChildren().size() > 0) {
                this.createTopicSetTree(topic.getChildren(), childTopic, tns, false);
            }
            root.addContent((Content)childTopic);
        }
    }
}

