/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLPrettyPrinter {
    private static String transformerFactoryClass = "";
    public static final ThreadLocal<TransformerFactory> transformerFactoryThreadLocal = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            try {
                if (System.getProperty("java.vendor").indexOf("Sun") != -1) {
                    transformerFactoryClass = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
                } else if (System.getProperty("java.vendor").indexOf("IBM") != -1) {
                    transformerFactoryClass = "org.apache.xalan.processor.TransformerFactoryImpl";
                }
                Thread.currentThread().getContextClassLoader().loadClass(transformerFactoryClass);
                System.setProperty("javax.xml.transform.TransformerFactory", transformerFactoryClass);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning. EasyXML : TransformerFactory '" + transformerFactoryClass + "' not found, the standard TransformerFactory will be used.");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            return transformerFactory;
        }
    };

    public static String prettyPrint(Document xmlDocument, String encoding) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLPrettyPrinter.prettify(xmlDocument, outStream, encoding);
            result = outStream.toString(encoding);
        }
        catch (Exception e) {
            System.err.println("write_dom failed:" + e);
        }
        return result;
    }

    public static String prettyPrint(Document xmlDocument) {
        return XMLPrettyPrinter.prettyPrint(xmlDocument, XMLPrettyPrinter.getEncoding(xmlDocument));
    }

    public static void prettify(Node node, OutputStream out, String encoding) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        TransformerFactory tf = transformerFactoryThreadLocal.get();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(source, new StreamResult(out));
    }

    public static String getEncoding(Document xmlDocument) {
        String encoding = xmlDocument.getInputEncoding();
        if (encoding == null) {
            encoding = xmlDocument.getXmlEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static Source getStyleSheetSource() {
        StreamSource stylesheetSource = new StreamSource(XMLPrettyPrinter.class.getResourceAsStream("/util/prettyPrint.xsl"));
        return stylesheetSource;
    }
}

