/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.service.client;

import javax.xml.namespace.QName;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageListener;

public abstract class WSAClient
implements Client {
    public static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";
    public static final String PREFIX = "wsa";
    public static final QName TO_QNAME = new QName("http://www.w3.org/2005/08/addressing", "To", "wsa");
    private String protocol;
    private String to;

    public WSAClient(String protocol, String to) {
        this.protocol = protocol;
        this.to = to;
    }

    public final void fireAndForget(Message message) throws ClientException {
        this.updateMessage(message);
        this.doFireAndForget(message);
    }

    protected abstract void doFireAndForget(Message var1) throws ClientException;

    public final Message sendReceive(Message message) throws ClientException {
        this.updateMessage(message);
        return this.doSendReceive(message);
    }

    protected abstract Message doSendReceive(Message var1) throws ClientException;

    public final void sendAsync(Message message, MessageListener listener) throws ClientException {
        this.updateMessage(message);
        this.doSendAsync(message, listener);
    }

    private void updateMessage(Message message) {
        String ns = String.format("http://petals.ow2.org/wsa/%s/", this.protocol);
        String serviceName = "WSAService";
        String itfName = "WSAInterface";
        String ep = "WSAEndpoint";
        QName service = new QName(ns, serviceName);
        QName interfaceQName = new QName(ns, itfName);
        String endpoint = ep;
        message.setService(service);
        message.setEndpoint(endpoint);
        message.setInterface(interfaceQName);
        message.setProperty(TO_QNAME.toString(), this.to);
    }

    protected abstract void doSendAsync(Message var1, MessageListener var2) throws ClientException;
}

