/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.xmlutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.commons.stream.ReaderInputStream;
import org.ow2.petals.commons.threadlocal.DocumentBuilders;
import org.ow2.petals.commons.threadlocal.Transformers;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLHelper {
    public static Document createDocument(Source source, boolean forkSource) throws Exception {
        Document document;
        block13: {
            document = null;
            try {
                if (source instanceof DOMSource) {
                    Node originalNode = ((DOMSource)source).getNode();
                    if (originalNode instanceof Document) {
                        Document originalDocument = (Document)originalNode;
                        if (forkSource) {
                            document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                            document.appendChild(document.importNode(originalDocument.getDocumentElement(), true));
                        } else {
                            document = originalDocument;
                        }
                    } else {
                        document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                        if (forkSource) {
                            document.appendChild(document.importNode(originalNode, true));
                        } else {
                            document.appendChild(document.adoptNode(originalNode));
                        }
                    }
                }
                if (document != null) break block13;
                Source tempSource = source;
                if (forkSource && source instanceof StreamSource) {
                    tempSource = new StreamSource(XMLHelper.forkStreamSource((StreamSource)source));
                }
                document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                DOMResult domResult = new DOMResult(document);
                Transformer transformer = Transformers.getDefaultTransformer();
                try {
                    transformer.transform(tempSource, domResult);
                }
                finally {
                    transformer.reset();
                }
            }
            catch (TransformerException e) {
                throw new Exception(e);
            }
        }
        return document;
    }

    private static final InputStream forkStreamSource(StreamSource streamSource) {
        InputStream isContent = streamSource.getInputStream();
        InputStreamForker streamForker = isContent != null ? new InputStreamForker(isContent) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader()));
        streamSource.setInputStream(streamForker.getInputStreamOne());
        return streamForker.getInputStreamTwo();
    }

    public static InputStream getInputStream(Document doc) throws IOException {
        return XMLHelper.createStreamSource(doc).getInputStream();
    }

    public static StreamSource createStreamSource(Document document) throws IOException {
        ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
        StreamResult sResult = new StreamResult(bufferOut);
        Transformer transformer = Transformers.getDefaultTransformer();
        try {
            try {
                transformer.transform(new DOMSource(document), sResult);
            }
            catch (TransformerException e) {
                throw new IOException("Error while transform DOM2 document to StreamSource", e);
            }
        }
        finally {
            transformer.reset();
        }
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
        return new StreamSource(bufferIn);
    }
}

