/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.ComponentWsdl;
import org.ow2.petals.component.framework.api.Component;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.api.notification.NotificationController;
import org.ow2.petals.component.framework.interceptor.description.InterceptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.ComponentInterceptor;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.mbean.InterceptorManager;
import org.ow2.petals.component.framework.mbean.MBeanHelper;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.notification.ComponentNotificationBrokerController;
import org.ow2.petals.component.framework.process.JBIAcceptorManager;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.async.AsyncMessageManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponent
implements Component {
    protected ComponentContext context;
    @Deprecated
    protected NotificationBrokerController notificationBrokerController = null;
    private NotificationController notificationController = null;
    private String registrationUuid = null;
    private JBIAcceptorManager acceptorManager;
    private AsyncMessageManager asyncManager;
    private DeliveryChannel channel;
    private ConfigurationExtensions componentExtensions;
    private Map<ServiceEndpointKey, ServiceEndpoint> componentServiceEndpoints;
    private InterceptorManager interceptorManager;
    private Map<String, Interceptor> interceptors;
    private Jbi jbiComponentConfiguration;
    private Logger logger;
    private Wsdl nativeWsdl = null;
    private JBIProcessorManager processorManager;
    private RuntimeConfigurationNotifier runtimeConfigurationNotifier;
    private AbstractServiceUnitManager suManager;

    public AsyncMessageManager getAsyncManager() {
        return this.asyncManager;
    }

    public DeliveryChannel getChannel() {
        return this.channel;
    }

    public org.ow2.petals.component.framework.jbidescriptor.generated.Component getComponentConfiguration() {
        return this.jbiComponentConfiguration.getComponent();
    }

    public ConfigurationExtensions getComponentExtensions() {
        return this.componentExtensions;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public ObjectName getExtensionMBeanName() {
        return null;
    }

    public Interceptor getInterceptor(String name) {
        Interceptor interceptor = null;
        if (this.interceptors != null) {
            interceptor = this.interceptors.get(name);
        }
        return interceptor;
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Wsdl getNativeWsdl() {
        return this.nativeWsdl;
    }

    @Deprecated
    public NotificationBrokerController getNotificationBrokerController() {
        return this.notificationBrokerController;
    }

    public NotificationController getNotificationController() {
        return this.notificationController;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        if (endpoint == null) {
            return null;
        }
        try {
            if (this.componentServiceEndpoints != null && !this.componentServiceEndpoints.isEmpty() && this.componentServiceEndpoints.get(new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName())) != null) {
                if (this.nativeWsdl != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.nativeWsdl.getDescription(), endpoint)) {
                    return this.nativeWsdl.getDocument();
                }
                if (this.notificationBrokerController != null) {
                    if (this.notificationBrokerController.getNotificationProducer() != null && this.notificationBrokerController.getNotificationProducer().getWsdl() != null && this.notificationBrokerController.getNotificationProducer().getWsdl().getDescription() != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.notificationBrokerController.getNotificationProducer().getWsdl().getDescription(), endpoint)) {
                        return this.notificationBrokerController.getNotificationProducer().getWsdl().getDocument();
                    }
                    if (this.notificationBrokerController.getNotificationConsumer() != null && this.notificationBrokerController.getNotificationConsumer().getWsdl() != null && this.notificationBrokerController.getNotificationConsumer().getWsdl().getDescription() != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.notificationBrokerController.getNotificationConsumer().getWsdl().getDescription(), endpoint)) {
                        return this.notificationBrokerController.getNotificationConsumer().getWsdl().getDocument();
                    }
                } else if (this.notificationController != null) {
                    if (this.notificationController.getProducerWsdl() != null && this.notificationController.getProducerWsdl().getDescription() != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.notificationController.getProducerWsdl().getDescription(), endpoint)) {
                        return this.notificationController.getProducerWsdl().getDocument();
                    }
                    if (this.notificationController.getConsumerWsdl() != null && this.notificationController.getConsumerWsdl().getDescription() != null && UtilFactory.getWSDLUtil().isDescriptionContaining(this.notificationController.getConsumerWsdl().getDescription(), endpoint)) {
                        return this.notificationController.getConsumerWsdl().getDocument();
                    }
                }
            }
        }
        catch (WSDLException e) {
            this.logger.warning("Unable to found the endpoint managed by the component: " + e.getMessage() + ". Search it into the Service Unit Manager...");
        }
        return this.suManager.getServiceDescription(endpoint);
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.suManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(ComponentContext compContext) throws JBIException {
        this.context = compContext;
        this.logger = this.context.getLogger("", this.getResourceBundleName());
        this.logger.info("Init component...");
        this.channel = this.context.getDeliveryChannel();
        File jbiXmlFile = new File(compContext.getInstallRoot() + File.separator + "META-INF" + File.separator + "jbi.xml");
        try {
            URL componentWsdlUrl;
            FileInputStream jbiInputStream = new FileInputStream(jbiXmlFile);
            try {
                this.jbiComponentConfiguration = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiInputStream);
            }
            finally {
                try {
                    jbiInputStream.close();
                }
                catch (IOException e) {}
            }
            this.componentExtensions = this.jbiComponentConfiguration.getComponent().getPropertiesFile() != null && !StringHelper.isNullOrEmpty(this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) ? new ConfigurationExtensions(this.jbiComponentConfiguration.getComponent().getAny(), this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) : new ConfigurationExtensions(this.jbiComponentConfiguration.getComponent().getAny());
            this.runtimeConfigurationNotifier = new RuntimeConfigurationNotifier(this.jbiComponentConfiguration, jbiXmlFile, this.logger);
            this.interceptors = this.loadInterceptors();
            this.interceptorManager = new InterceptorManager(this, this.jbiComponentConfiguration, jbiXmlFile);
            if (this.suManager == null) {
                this.suManager = this.createServiceUnitManager();
            }
            if ((componentWsdlUrl = AbstractComponent.class.getResource("/component.wsdl")) != null) {
                this.nativeWsdl = new ComponentWsdl(UtilFactory.getWSDLUtil().createWsdlDescription(AbstractComponent.class.getResource("/component.wsdl"), true));
            }
            if (this.getComponentConfiguration().getNotifications() != null && this.getComponentConfiguration().getNotifications().isValue()) {
                this.notificationBrokerController = new ComponentNotificationBrokerController(this.logger, this.context);
            }
            this.componentServiceEndpoints = new ConcurrentHashMap<ServiceEndpointKey, ServiceEndpoint>();
        }
        catch (CDKJBIDescriptorException e) {
            throw new JBIException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new JBIException((Throwable)e);
        }
        catch (PEtALSCDKException e) {
            throw new JBIException((Throwable)e);
        }
        catch (WSDLException e) {
            throw new JBIException((Throwable)e);
        }
        catch (WSNotificationException e) {
            throw new JBIException((Throwable)e);
        }
        catch (WSAddressingException e) {
            throw new JBIException((Throwable)e);
        }
        catch (WSNotificationExtensionException e) {
            throw new JBIException((Throwable)e);
        }
        this.logger.fine("Calling specific initialization...");
        this.doInit();
        this.logger.fine("Specific initialization done.");
        this.processorManager = new JBIProcessorManager(this, this.runtimeConfigurationNotifier, this.logger);
        this.acceptorManager = new JBIAcceptorManager(this, this.processorManager, this.runtimeConfigurationNotifier, this.logger);
        this.asyncManager = new AsyncMessageManager(this.logger, this.processorManager);
        this.logger.info("Component initialized");
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutDown() throws JBIException {
        this.logger.info("Shutdown component...");
        try {
            this.logger.fine("Calling specific shutdown...");
            this.doShutdown();
            this.logger.fine("Specific shutdown done.");
            Object var2_1 = null;
            this.nativeWsdl = null;
            this.notificationBrokerController = null;
            this.notificationController = null;
            if (this.componentServiceEndpoints != null) {
                this.componentServiceEndpoints.clear();
                this.componentServiceEndpoints = null;
            }
            this.channel = null;
            this.runtimeConfigurationNotifier = null;
            this.interceptors = null;
            this.interceptorManager = null;
            this.acceptorManager = null;
            this.processorManager = null;
            this.asyncManager = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.nativeWsdl = null;
            this.notificationBrokerController = null;
            this.notificationController = null;
            if (this.componentServiceEndpoints != null) {
                this.componentServiceEndpoints.clear();
                this.componentServiceEndpoints = null;
            }
            this.channel = null;
            this.runtimeConfigurationNotifier = null;
            this.interceptors = null;
            this.interceptorManager = null;
            this.acceptorManager = null;
            this.processorManager = null;
            this.asyncManager = null;
            throw throwable;
        }
        this.logger.info("Component turned off");
    }

    public final void start() throws JBIException {
        this.logger.info("Start component...");
        if (this.channel == null) {
            this.channel = this.context.getDeliveryChannel();
        }
        this.registerRuntimeConfigMBean();
        this.registerInterceptorManagerMBean();
        this.processorManager.start();
        this.acceptorManager.start();
        this.asyncManager.start();
        this.activateServiceEndpointList();
        if (this.notificationBrokerController != null) {
            try {
                this.notificationBrokerController.registerPublisher();
            }
            catch (WSNotificationException e) {
                this.logger.warning("unable to register the publisher: no notification will be sent");
                this.logger.fine("detail on the error: " + e.getMessage());
                this.notificationBrokerController = null;
            }
            catch (WSAddressingException e) {
                this.logger.warning("unable to register the publisher: no notification will be sent");
                this.logger.fine("detail on the error: " + e.getMessage());
                this.notificationBrokerController = null;
            }
            catch (WSNotificationExtensionException e) {
                this.logger.warning("unable to register the publisher: no notification will be sent");
                this.logger.fine("detail on the error: " + e.getMessage());
                this.notificationBrokerController = null;
            }
            catch (MessagingException e) {
                this.logger.warning("unable to register the publisher: no notification will be sent");
                this.logger.fine("detail on the error: " + e.getMessage());
                this.notificationBrokerController = null;
            }
        }
        if (this.notificationController != null) {
            try {
                this.registrationUuid = this.notificationController.registerPublisher("http://petals.ow2.org/topic", "component/cdk//*[@wstop:topic='true']");
            }
            catch (Exception e) {
                this.logger.warning("unable to register the publisher: no notification will be sent");
                this.logger.fine("detail on the error: " + e.getMessage());
                this.notificationController = null;
            }
        }
        this.logger.fine("Calling specific start...");
        this.doStart();
        this.logger.info("Component started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws JBIException {
        block18: {
            Throwable e22;
            block17: {
                this.logger.info("Stop component...");
                try {
                    this.logger.fine("Calling specific stop...");
                    this.doStop();
                    this.logger.fine("Specific stop done.");
                    Object var2_1 = null;
                    if (this.notificationBrokerController == null) break block17;
                }
                catch (Throwable throwable) {
                    Throwable e22;
                    Object var2_2 = null;
                    if (this.notificationBrokerController != null) {
                        try {
                            this.notificationBrokerController.destroyRegistration();
                        }
                        catch (WSNotificationException e22) {
                            this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                            this.logger.fine("detail on the error: " + e22.getMessage());
                            this.notificationBrokerController = null;
                        }
                        catch (WSAddressingException e22) {
                            this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                            this.logger.fine("detail on the error: " + e22.getMessage());
                            this.notificationBrokerController = null;
                        }
                        catch (WSNotificationExtensionException e22) {
                            this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                            this.logger.fine("detail on the error: " + e22.getMessage());
                            this.notificationBrokerController = null;
                        }
                        catch (MessagingException e22) {
                            this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                            this.logger.fine("detail on the error: " + e22.getMessage());
                            this.notificationBrokerController = null;
                        }
                    }
                    if (this.notificationController != null) {
                        try {
                            this.notificationController.destroyRegistration(this.registrationUuid);
                        }
                        catch (Exception e22) {
                            this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                            this.logger.fine("detail on the error: " + e22.getMessage());
                            this.notificationController = null;
                        }
                    }
                    this.deactivateServiceEndpointList();
                    this.unregisterRuntimeConfigurationMBean();
                    this.unregisterInterceptorManagerMBean();
                    this.acceptorManager.stop();
                    this.processorManager.stop();
                    this.asyncManager.stop();
                    throw throwable;
                }
                try {
                    this.notificationBrokerController.destroyRegistration();
                }
                catch (WSNotificationException e22) {
                    this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                    this.logger.fine("detail on the error: " + e22.getMessage());
                    this.notificationBrokerController = null;
                }
                catch (WSAddressingException e22) {
                    this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                    this.logger.fine("detail on the error: " + e22.getMessage());
                    this.notificationBrokerController = null;
                }
                catch (WSNotificationExtensionException e22) {
                    this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                    this.logger.fine("detail on the error: " + e22.getMessage());
                    this.notificationBrokerController = null;
                }
                catch (MessagingException e22) {
                    this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                    this.logger.fine("detail on the error: " + e22.getMessage());
                    this.notificationBrokerController = null;
                }
            }
            if (this.notificationController != null) {
                try {
                    this.notificationController.destroyRegistration(this.registrationUuid);
                    break block18;
                }
                catch (Exception e22) {
                    this.logger.warning("unable to destroy the registration of the publisher: the broker will try to send me notifications");
                    this.logger.fine("detail on the error: " + e22.getMessage());
                    this.notificationController = null;
                }
                {
                }
            }
        }
        this.deactivateServiceEndpointList();
        this.unregisterRuntimeConfigurationMBean();
        this.unregisterInterceptorManagerMBean();
        this.acceptorManager.stop();
        this.processorManager.stop();
        this.asyncManager.stop();
        this.logger.info("Component stopped");
    }

    protected abstract AbstractServiceUnitManager createServiceUnitManager();

    protected void doInit() throws JBIException {
    }

    protected void doShutdown() throws JBIException {
    }

    protected void doStart() throws JBIException {
    }

    protected void doStop() throws JBIException {
    }

    protected String getResourceBundleName() {
        return null;
    }

    private void activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        final QName s = serviceName;
        final String e = endpointName;
        this.componentServiceEndpoints.put(new ServiceEndpointKey(serviceName, endpointName), new ServiceEndpoint(){

            public DocumentFragment getAsReference(QName operationName) {
                return null;
            }

            public String getEndpointName() {
                return e;
            }

            public QName[] getInterfaces() {
                return null;
            }

            public QName getServiceName() {
                return s;
            }
        });
        ServiceEndpoint se = this.context.activateEndpoint(serviceName, endpointName);
        this.componentServiceEndpoints.put(new ServiceEndpointKey(serviceName, endpointName), se);
    }

    private void activateServiceEndpointList() throws JBIException {
        try {
            Endpoint endpoint;
            Iterator iterator;
            QName serviceName = null;
            String endpointName = null;
            List endpointList = null;
            if (this.nativeWsdl != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.nativeWsdl.getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                while (iterator.hasNext()) {
                    endpoint = (Endpoint)iterator.next();
                    if (endpoint == null) continue;
                    serviceName = ((Service)endpoint.getService()).getQName();
                    endpointName = endpoint.getName();
                    this.activateEndpoint(serviceName, endpointName);
                }
            }
            if (this.notificationBrokerController != null) {
                if (this.notificationBrokerController.getNotificationProducer() != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.notificationBrokerController.getNotificationProducer().getWsdl().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                    while (iterator.hasNext()) {
                        endpoint = (Endpoint)iterator.next();
                        if (endpoint == null) continue;
                        serviceName = ((Service)endpoint.getService()).getQName();
                        endpointName = endpoint.getName();
                        this.activateEndpoint(serviceName, endpointName);
                    }
                }
                if (this.notificationBrokerController.getNotificationConsumer() != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.notificationBrokerController.getNotificationConsumer().getWsdl().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                    while (iterator.hasNext()) {
                        endpoint = (Endpoint)iterator.next();
                        if (endpoint == null) continue;
                        serviceName = ((Service)endpoint.getService()).getQName();
                        endpointName = endpoint.getName();
                        this.activateEndpoint(serviceName, endpointName);
                    }
                }
            }
            if (this.notificationController != null) {
                if (this.notificationController.getProducerWsdl() != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.notificationController.getProducerWsdl().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                    while (iterator.hasNext()) {
                        endpoint = (Endpoint)iterator.next();
                        if (endpoint == null) continue;
                        serviceName = ((Service)endpoint.getService()).getQName();
                        endpointName = endpoint.getName();
                        this.activateEndpoint(serviceName, endpointName);
                    }
                }
                if (this.notificationController.getConsumerWsdl() != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.notificationController.getConsumerWsdl().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                    while (iterator.hasNext()) {
                        endpoint = (Endpoint)iterator.next();
                        if (endpoint == null) continue;
                        serviceName = ((Service)endpoint.getService()).getQName();
                        endpointName = endpoint.getName();
                        this.activateEndpoint(serviceName, endpointName);
                    }
                }
            }
        }
        catch (WSDLException e) {
            throw new JBIException("Unable to activate the endpoints managed by the component", (Throwable)e);
        }
    }

    private void deactivateServiceEndpointList() throws JBIException {
        if (this.componentServiceEndpoints != null) {
            for (ServiceEndpointKey key : this.componentServiceEndpoints.keySet()) {
                this.context.deactivateEndpoint(this.componentServiceEndpoints.get(key));
            }
            this.componentServiceEndpoints.clear();
        }
    }

    private final Map<String, Interceptor> loadInterceptors() {
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        if (this.jbiComponentConfiguration.getComponent().getComponentInterceptors() != null) {
            for (ComponentInterceptor componentInterceptor : this.jbiComponentConfiguration.getComponent().getComponentInterceptors().getInterceptor()) {
                try {
                    this.logger.info("Loading interceptor : " + componentInterceptor.getName());
                    Interceptor itc = InterceptorBuilder.loadInstance(componentInterceptor.getClazz());
                    ConfigurationExtensions configurationExtensions = this.jbiComponentConfiguration.getComponent().getPropertiesFile() != null && !StringHelper.isNullOrEmpty(this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) ? new ConfigurationExtensions(componentInterceptor.getParam(), this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) : new ConfigurationExtensions(componentInterceptor.getParam());
                    itc.init((Component)this, componentInterceptor.getName(), componentInterceptor.isActive(), (Map)configurationExtensions, this.logger);
                    interceptors.put(componentInterceptor.getName(), itc);
                }
                catch (PEtALSCDKException e) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : " + e.getMessage());
                }
            }
        }
        return interceptors;
    }

    private void registerInterceptorManagerMBean() throws JBIException {
        ObjectName mbeanName = this.context.getMBeanNames().createCustomComponentMBeanName("interceptors_" + this.context.getComponentName());
        this.interceptorManager.setMBeanName(mbeanName);
        MBeanHelper.registerMBean(this.context.getMBeanServer(), mbeanName, this.interceptorManager);
    }

    private void registerRuntimeConfigMBean() throws JBIException {
        ObjectName runtimeConfigurationMBeanName = this.context.getMBeanNames().createCustomComponentMBeanName("runtime_configuration_" + this.context.getComponentName());
        this.runtimeConfigurationNotifier.setMBeanName(runtimeConfigurationMBeanName);
        MBeanHelper.registerMBean(this.context.getMBeanServer(), runtimeConfigurationMBeanName, this.runtimeConfigurationNotifier);
    }

    private void unregisterInterceptorManagerMBean() throws JBIException {
        MBeanHelper.unregisterMBean(this.context.getMBeanServer(), this.interceptorManager.getMBeanName());
    }

    private void unregisterRuntimeConfigurationMBean() throws JBIException {
        MBeanHelper.unregisterMBean(this.context.getMBeanServer(), this.runtimeConfigurationNotifier.getMBeanName());
    }
}

