/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.message;

import java.util.concurrent.ConcurrentHashMap;
import org.ow2.petals.messaging.framework.lifecycle.NullLifeCycle;
import org.ow2.petals.messaging.framework.message.Callback;
import org.ow2.petals.messaging.framework.message.Client;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.message.MessagingEngine;
import org.ow2.petals.messaging.framework.message.MessagingException;

public class MessagingEngineImpl
extends NullLifeCycle
implements MessagingEngine {
    private final ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();

    public final void addClient(String protocol, Client client) {
        if (protocol == null || client == null) {
            throw new NullPointerException("Protocol and client can not be null");
        }
        this.clients.put(protocol, client);
    }

    public Client getClient(String protocol) {
        return this.clients.get(protocol);
    }

    public Message send(Message message) throws MessagingException {
        if (message == null) {
            throw new MessagingException("Null message");
        }
        String protocol = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Protocol");
        if (protocol == null) {
            throw new MessagingException("Null protocol, please set the com.ebmwebsourcing.commons.ws.framework.Protocol String property in the message");
        }
        Client client = this.clients.get(protocol);
        if (client == null) {
            throw new MessagingException("Client is null for protocol '" + protocol + "'");
        }
        return client.send(message);
    }

    public void send(final Message message, final Callback callback) throws MessagingException {
        if (message == null) {
            throw new MessagingException("Message can not be null");
        }
        if (callback == null) {
            throw new MessagingException("Callback handler can not be null");
        }
        Runnable r = new Runnable(){

            public void run() {
                String protocol = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Protocol");
                Client client = (Client)MessagingEngineImpl.this.clients.get(protocol);
                if (client == null) {
                    callback.onError(new MessagingException("No client found in messaging engine for protocol " + protocol));
                }
                try {
                    Message response = client.send(message);
                    callback.onMessage(response);
                }
                catch (MessagingException e) {
                    callback.onError(e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void receive(Message message) throws MessagingException {
    }
}

