/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.message.mime.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.message.MessageImpl;
import org.ow2.petals.messaging.framework.message.mime.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XwwwFormURLEncodedReader
implements Reader {
    @Override
    public Message read(InputStream is, String encoding) {
        MessageImpl message = new MessageImpl();
        try {
            message.putAll(this.getXFormContent(is, encoding));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return message;
    }

    Map<String, Object> getXFormContent(final InputStream is, final String encoding) throws UnsupportedEncodingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = (InputStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnsupportedEncodingException {
                    return new InputStreamReader(is, encoding);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnsupportedEncodingException)e.getException();
        }
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] parts = line.split("&");
                int i = 0;
                while (i < parts.length) {
                    int separator = parts[i].indexOf("=");
                    String key = parts[i].substring(0, separator);
                    String value = parts[i].substring(separator + 1);
                    result.put("com.ebmwebsourcing.commons.ws.framework.parameters." + i + "." + key, value);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

