/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.plugins.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.messaging.framework.EngineException;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.NullLifeCycle;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.plugins.Handler;
import org.ow2.petals.messaging.framework.plugins.HandlerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerManager
extends NullLifeCycle
implements Handler,
LifeCycle {
    private final Map<Class<?>, List<Handler>> handlers;
    private final Log logger = LogFactory.getLog(HandlerManager.class);

    public HandlerManager() {
        this.handlers = new HashMap();
    }

    @Override
    public String getName() {
        return null;
    }

    public <T> void addHandler(Class<T> type, Handler handler) throws EngineException {
        if (this.isStarted()) {
            throw new EngineException("Can not add handler while started");
        }
        if (this.handlers.get(type) == null) {
            this.handlers.put(type, new ArrayList());
        }
        this.handlers.get(type).add(handler);
    }

    @Override
    public void handle(Message message) throws HandlerException {
        if (!this.isStarted()) {
            throw new HandlerException("Can not handle while not started");
        }
        if (message == null) {
            return;
        }
        Set<Class<?>> set = this.handlers.keySet();
        for (Class<?> class1 : set) {
            if (message.getContent(class1) == null) continue;
            List<Handler> handlers = this.handlers.get(class1);
            for (Handler handler : handlers) {
                this.logger.info((Object)("Handling message for handler " + handler.getClass().getCanonicalName()));
                try {
                    handler.handle(message);
                }
                catch (HandlerException e) {
                    String s = "Exception on handling message : " + e.getMessage();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn((Object)s, (Throwable)e);
                        continue;
                    }
                    this.logger.warn((Object)s);
                }
            }
        }
    }
}

