/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.plugins.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.NullLifeCycle;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.plugins.Handler;
import org.ow2.petals.messaging.framework.plugins.HandlerException;

public class OperationHandlerManager
extends NullLifeCycle
implements Handler,
LifeCycle {
    public static final String OPERTATION = "operation";
    Map<String, Set<Handler>> handlers;
    private final Log logger = LogFactory.getLog(OperationHandlerManager.class);

    public OperationHandlerManager() {
        this.handlers = new HashMap<String, Set<Handler>>();
    }

    public String getName() {
        return "OperationHandlerManager";
    }

    public void handle(Message message) throws HandlerException {
        if (message != null && message.get(OPERTATION) != null) {
            Set<Handler> set = this.handlers.get(message.get(OPERTATION));
            for (Handler handler : set) {
                this.logger.debug((Object)("Handling message in handler " + handler.getName()));
                handler.handle(message);
            }
        }
    }

    public final void addHandler(String operationName, Handler handler) {
        if (operationName == null || handler == null) {
            return;
        }
        if (this.handlers.get(operationName) == null) {
            this.handlers.put(operationName, new HashSet());
        }
        this.handlers.get(operationName).add(handler);
    }
}

