/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private byte[] internalBuffer = null;
    private int internalBufferPos = 0;

    public ReaderInputStream(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null.");
        }
        this.reader = reader;
    }

    public int available() throws IOException {
        int availableChar;
        if (this.reader.ready() && (availableChar = this.reader.read()) != -1) {
            if (this.internalBuffer != null) {
                byte[] newBuffer = new byte[this.internalBuffer.length + 1];
                System.arraycopy(this.internalBuffer, 0, newBuffer, 0, this.internalBuffer.length);
                newBuffer[newBuffer.length - 1] = (byte)availableChar;
                this.internalBuffer = newBuffer;
            } else {
                this.internalBuffer = new String(new char[]{(char)availableChar}).getBytes();
                this.internalBufferPos = 0;
            }
        }
        return this.internalBuffer == null ? 0 : this.internalBuffer.length - this.internalBufferPos;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int nbByteRead = this.read(buffer);
        if (nbByteRead != 1) {
            throw new IOException("No byte read.");
        }
        return buffer[0];
    }

    public int read(byte[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(byte[] cbuf, int off, int len) throws IOException {
        return this.localRead(cbuf, off, len, false);
    }

    public long skip(long n) throws IOException, IllegalArgumentException {
        if (n > Long.MAX_VALUE) {
            throw new IllegalArgumentException("Only value lesser 2147483647are accepted.");
        }
        return this.localRead(null, 0, (int)n, true);
    }

    private int localRead(byte[] buf, int off, int len, boolean skip) throws IOException {
        int bytesToReadInInternalBuffer;
        int remainingLen = len;
        int offset = off;
        int n = bytesToReadInInternalBuffer = this.internalBuffer == null ? 0 : Math.min(len, this.internalBuffer.length - this.internalBufferPos);
        if (bytesToReadInInternalBuffer > 0) {
            if (!skip) {
                System.arraycopy(this.internalBuffer, this.internalBufferPos, buf, offset, bytesToReadInInternalBuffer);
            }
            remainingLen -= bytesToReadInInternalBuffer;
            this.internalBufferPos += bytesToReadInInternalBuffer;
        }
        if (remainingLen > 0) {
            offset += bytesToReadInInternalBuffer;
            char[] cbuf = new char[remainingLen];
            int charRead = this.reader.read(cbuf, 0, remainingLen);
            if (charRead == -1) {
                if (len == remainingLen) {
                    return -1;
                }
                return len - remainingLen;
            }
            this.internalBuffer = new String(cbuf, 0, charRead).getBytes();
            this.internalBufferPos = 0;
            bytesToReadInInternalBuffer = Math.min(remainingLen, charRead);
            if (!skip) {
                System.arraycopy(this.internalBuffer, 0, buf, offset, bytesToReadInInternalBuffer);
            }
            this.internalBufferPos += bytesToReadInInternalBuffer;
            return bytesToReadInInternalBuffer;
        }
        return len;
    }
}

