/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.messaging.framework.EngineException;
import org.ow2.petals.messaging.framework.utils.DocumentBuilders;
import org.ow2.petals.messaging.framework.utils.InputStreamForker;
import org.ow2.petals.messaging.framework.utils.ReaderInputStream;
import org.ow2.petals.messaging.framework.utils.Transformers;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Source createSource(String message) throws IOException {
        String charsetEncoding = Charset.defaultCharset().displayName();
        return XMLUtil.createSource(message, charsetEncoding);
    }

    public static Source createSource(String message, String charFormat) throws IOException {
        StreamSource source = new StreamSource();
        byte[] msgByte = message.getBytes(charFormat);
        ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
        source.setInputStream(in);
        return source;
    }

    public static String createString(Source source, boolean forkSource) throws EngineException {
        Source tempSource = source;
        if (forkSource && source instanceof StreamSource) {
            tempSource = new StreamSource(XMLUtil.forkStreamSource((StreamSource)source));
        }
        try {
            StringWriter buffer = new StringWriter();
            StreamResult sresult = new StreamResult(buffer);
            Transformer transformer = Transformers.getDefaultTransformer();
            try {
                transformer.transform(tempSource, sresult);
            }
            finally {
                transformer.reset();
            }
            return buffer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new EngineException(e);
        }
        catch (TransformerException e) {
            throw new EngineException(e);
        }
    }

    public static Document loadDocument(InputStream inputStream) throws IOException, SAXException {
        Document document = null;
        try {
            document = DocumentBuilders.getNamespaceDocumentBuilder().parse(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public static StreamSource createStreamSource(Document document) throws EngineException {
        ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
        StreamResult sResult = new StreamResult(bufferOut);
        Transformer transformer = Transformers.getDefaultTransformer();
        try {
            try {
                transformer.transform(new DOMSource(document), sResult);
            }
            catch (TransformerException e) {
                throw new EngineException("Error while transform DOM2 document to StreamSource", e);
            }
        }
        finally {
            transformer.reset();
        }
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
        return new StreamSource(bufferIn);
    }

    private static final InputStream forkStreamSource(StreamSource streamSource) {
        InputStream isContent = streamSource.getInputStream();
        InputStreamForker streamForker = isContent != null ? new InputStreamForker(isContent) : new InputStreamForker(new ReaderInputStream(streamSource.getReader()));
        streamSource.setInputStream(streamForker.getInputStreamOne());
        return streamForker.getInputStreamTwo();
    }
}

