/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaReader;
import org.ow2.easywsdl.schema.impl.SchemaImpl;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;
import org.ow2.easywsdl.schema.util.EasyXMLFilter;
import org.ow2.easywsdl.schema.util.URILocationResolver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaReaderImpl
extends AbstractSchemaReader
implements SchemaReader {
    private static Logger log = Logger.getLogger(SchemaReaderImpl.class.getName());
    private Map<SchemaReader.FeatureConstants, Object> features = new HashMap<SchemaReader.FeatureConstants, Object>();
    private Map<URI, AbsItfSchema> importList = new HashMap<URI, AbsItfSchema>();
    private final URILocationResolver schemaLocationResolver = new URILocationResolver();
    private URI documentBaseURI;
    private static SchemaJAXBContext jaxbcontext = null;
    private static SchemaException contextException = null;

    public static SchemaJAXBContext getJaxbContext() throws SchemaException {
        if (contextException != null) {
            throw contextException;
        }
        return jaxbcontext;
    }

    public SchemaReaderImpl() throws SchemaException {
        SchemaReaderImpl.getJaxbContext();
        this.features.put(SchemaReader.FeatureConstants.VERBOSE, false);
        this.features.put(SchemaReader.FeatureConstants.IMPORT_DOCUMENTS, true);
    }

    @Override
    public void setDocumentBaseURI(URI documentBaseURI) {
        this.documentBaseURI = documentBaseURI;
    }

    @Override
    public URI getDocumentBaseURI() {
        return this.documentBaseURI;
    }

    @Override
    public Schema read(URL schemaURL) throws SchemaException, URISyntaxException, IOException {
        try {
            InputStream stream = schemaURL.openStream();
            if (stream == null) {
                throw new SchemaException("Ressource not found at url: " + schemaURL);
            }
            InputSource inputSource = new InputSource(stream);
            inputSource.setSystemId(schemaURL.toString());
            return this.read(inputSource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The provided well-formed URL has been detected as malformed !!");
        }
    }

    @Override
    public Schema read(InputSource inputSource) throws SchemaException, URISyntaxException, MalformedURLException {
        this.documentBaseURI = inputSource.getSystemId() != null ? new URI(inputSource.getSystemId()) : new URI(".");
        return this.readSchema(inputSource, null, true);
    }

    @Override
    public Schema read(Document doc) throws SchemaException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(baos);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(doc), streamResult);
            baos.flush();
            baos.close();
            InputSource documentInputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            documentInputSource.setSystemId(doc.getBaseURI());
            return this.read(documentInputSource);
        }
        catch (TransformerConfigurationException e) {
            throw new SchemaException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SchemaException(e);
        }
        catch (TransformerException e) {
            throw new SchemaException(e);
        }
        catch (IOException e) {
            throw new SchemaException(e);
        }
        catch (URISyntaxException e) {
            throw new SchemaException(e);
        }
    }

    @Override
    protected Schema readExternalPart(URI schemaLocationURI, URI baseURI, Map<URI, AbsItfSchema> imports, boolean deleteImports) throws SchemaException, MalformedURLException, URISyntaxException {
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(this.schemaLocationResolver.resolve(baseURI, schemaLocationURI).openStream());
            inputSource.setSystemId(this.schemaLocationResolver.resolve(baseURI, schemaLocationURI).toString());
        }
        catch (IOException e) {
            throw new SchemaException(e);
        }
        return this.readSchema(inputSource, imports, deleteImports);
    }

    private Schema readSchema(InputSource source, Map<URI, AbsItfSchema> imports, boolean deleteImports) throws SchemaException, MalformedURLException, URISyntaxException {
        if (deleteImports) {
            this.getImportList().clear();
        }
        try {
            URI systemIdURI;
            String systemId = source.getSystemId();
            if (systemId != null) {
                systemIdURI = new URI(systemId);
                this.setDocumentBaseURI(systemIdURI);
            } else {
                systemIdURI = new File(".").toURI();
            }
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            EasyXMLFilter filter = new EasyXMLFilter(xmlReader);
            SAXSource saxSource = new SAXSource(filter, source);
            log.fine("Loading " + systemIdURI);
            JAXBElement<org.ow2.easywsdl.schema.org.w3._2001.xmlschema.Schema> schemaBinding = SchemaReaderImpl.getJaxbContext().getJaxbContext().createUnmarshaller().unmarshal(saxSource, org.ow2.easywsdl.schema.org.w3._2001.xmlschema.Schema.class);
            org.ow2.easywsdl.schema.org.w3._2001.xmlschema.Schema def = schemaBinding.getValue();
            return new SchemaImpl(systemIdURI, def, filter.getNamespaceMapper(), filter.getSchemaLocator(), this.getFeatures(), imports, this);
        }
        catch (SAXException e) {
            throw new SchemaException("Can not get schema: ", e);
        }
        catch (JAXBException e) {
            throw new SchemaException("Can not get schema: ", e);
        }
    }

    @Override
    public void setFeature(SchemaReader.FeatureConstants name, Object value) throws IllegalArgumentException {
        this.features.put(name, value);
        log.finest("set features: name = " + (Object)((Object)name) + " - value = " + value);
    }

    @Override
    public Object getFeature(SchemaReader.FeatureConstants name) throws IllegalArgumentException {
        return this.features.get((Object)name);
    }

    @Override
    public Map<SchemaReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(Map<SchemaReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    @Override
    protected Map<URI, AbsItfSchema> getImportList() {
        return this.importList;
    }

    protected void setImportList(Map<URI, AbsItfSchema> importLists) {
        this.importList = importLists;
    }

    static {
        try {
            jaxbcontext = new SchemaJAXBContext();
        }
        catch (SchemaException e) {
            contextException = e;
        }
    }
}

