/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.brokerednotification.impl;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrPublisherRegistrationManager;
import com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrRegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceNotDestroyedFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.persistence.WsnPersistence;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationsMgr
implements WsnbrRegisterPublisher,
WsnbrPublisherRegistrationManager {
    private Logger logger;
    private String publisherRegistrationMgrEdpAddress = "http://www.ebmwebsourcing.com/PublisherRegistrationManager/default";
    private QName publisherRegistrationMgrServiceQName = new QName("http://www.ebmwebsourcing.com/default", "PublisherRegistrationManagerService");
    private QName publisherRegistrationMgrInterfaceQName = new QName("http://www.ebmwebsourcing.com/default", "PublisherRegistrationManager");
    private String notificationBrokerEdp = "http://www.ebmwebsourcing.com/NotificationBorker/default";
    private QName notificationBrokerService = new QName("http://www.ebmwebsourcing.com/default", "NotificationBorkerService");
    private QName notificationBrokerInterface = new QName("http://www.ebmwebsourcing.com/default", "NotificationBorker");
    private Map<String, PublisherRegistrationRP> registrations;
    private WstopTopicManager topicsMgr;
    private WsnPersistence persistenceMgr = null;

    public RegistrationsMgr(Logger logger, WstopTopicManager topicsMgr, WsnPersistence persistenceMgr) {
        this.logger = logger;
        this.registrations = Collections.synchronizedMap(new HashMap());
        this.topicsMgr = topicsMgr;
        this.persistenceMgr = persistenceMgr;
    }

    public RegistrationsMgr(Logger logger, WstopTopicManager topicsMgr) {
        this.logger = logger;
        this.registrations = Collections.synchronizedMap(new HashMap());
        this.topicsMgr = topicsMgr;
        this.persistenceMgr = null;
    }

    public RegistrationsMgr(Logger logger) {
        this.logger = logger;
        this.registrations = Collections.synchronizedMap(new HashMap());
        this.topicsMgr = null;
        this.persistenceMgr = null;
    }

    public void setPublisherRegistrationMgrEdpAddress(String publisherRegisterEdpAddress) {
        this.publisherRegistrationMgrEdpAddress = publisherRegisterEdpAddress;
    }

    public void setPublisherRegistrationMgrInterfaceQName(QName publisherRegisterInterfaceQName) {
        this.publisherRegistrationMgrInterfaceQName = publisherRegisterInterfaceQName;
    }

    public void setPublisherRegistrationMgrServiceQName(QName publisherRegisterServiceQName) {
        this.publisherRegistrationMgrServiceQName = publisherRegisterServiceQName;
    }

    public void setNotificationBrokerEdp(String notificationBrokerEdp) {
        this.notificationBrokerEdp = notificationBrokerEdp;
    }

    public void setNotificationBrokerService(QName notificationBrokerService) {
        this.notificationBrokerService = notificationBrokerService;
    }

    public void setNotificationBrokerInterface(QName notificationBrokerInterface) {
        this.notificationBrokerInterface = notificationBrokerInterface;
    }

    public EndpointReferenceType getPublisherEdpRefOfRegistration(String registrationId) throws WSNotificationException {
        EndpointReferenceType publisherEdp = null;
        PublisherRegistrationRP storedRP = this.registrations.get(registrationId);
        if (storedRP != null) {
            publisherEdp = storedRP.getPublisherReference();
        }
        return publisherEdp;
    }

    public List<EndpointReferenceType> getPublisherEdpRefOfRegistration(List<String> registrationIds) throws WSNotificationException {
        ArrayList<EndpointReferenceType> publisherEdps = new ArrayList<EndpointReferenceType>();
        for (String regIdItem : registrationIds) {
            publisherEdps.add(this.registrations.get(regIdItem).getPublisherReference());
        }
        return publisherEdps;
    }

    @Override
    public RegisterPublisherResponse registerPublisher(RegisterPublisher request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        this.logger.log(Level.FINE, "performs a \"RegisterPublisher\" request ...");
        this.logger.log(Level.FINE, "\"RegisterPublisher\" method implementation in progress !");
        RegisterPublisherResponse response = null;
        List<TopicExpressionType> topics = request.getTopic();
        for (TopicExpressionType topicExpressionType : topics) {
            if (request.getPublisherReference() != null && this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "PublisherReference : " + request.getPublisherReference().getAddress());
            }
            if (request.getInitialTerminationTime() != null && this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "initial termination Time : " + request.getInitialTerminationTime().toString());
            }
            if (topicExpressionType != null && this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Dialect : " + topicExpressionType.getDialect());
                this.logger.log(Level.FINE, "Topic content : " + topicExpressionType.getContent());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                for (QName nsToDisplay : topicExpressionType.getTopicNameSpace()) {
                    this.logger.log(Level.FINE, "Topic Namespace(s) content : " + nsToDisplay);
                }
            }
            try {
                PublisherRegistrationRP registration = null;
                String registrationId = UUID.randomUUID().toString();
                this.topicsMgr.storeNewRegistration(topicExpressionType, registrationId);
                EndpointReferenceType registrationEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
                registrationEdpRef.setAddress(request.getPublisherReference().getAddress());
                ReferenceParametersType ref = (ReferenceParametersType)registrationEdpRef.newReferenceParameters();
                registrationEdpRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
                SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
                soaParam.setService(this.publisherRegistrationMgrServiceQName);
                soaParam.setInterface(this.publisherRegistrationMgrInterfaceQName);
                soaParam.setEndpoint(this.publisherRegistrationMgrEdpAddress);
                WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
                ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
                rUuids.addUuid(registrationId);
                WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)rUuids, (ReferenceParametersType)ref);
                registration = WSNotificationFactory.getInstance().createPublisherRegistrationRP();
                registration.setPublisherReference(request.getPublisherReference());
                List<TopicExpressionType> topExprLists = request.getTopic();
                for (TopicExpressionType topExpItem : topExprLists) {
                    registration.addTopic(topExpItem);
                }
                registration.setDemand(request.isDemand());
                registration.setCreationTime(new GregorianCalendar().getTime());
                this.registrations.put(registrationId, registration);
                if (this.persistenceMgr != null) {
                    this.persistenceMgr.persist(registration, registrationId);
                }
                response = WSNotificationFactory.getInstance().createRegisterPublisherResponse();
                response.setPublisherRegistrationReference(registrationEdpRef);
                if (request.isDemand()) continue;
                EndpointReferenceType consumerRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
                consumerRef.setAddress(request.getPublisherReference().getAddress());
                ReferenceParametersType consRefPar = (ReferenceParametersType)consumerRef.newReferenceParameters();
                consumerRef.setReferenceParameters((AbsItfReferenceParametersType)consRefPar);
                SOAParameterType consSoaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
                consSoaParam.setService(this.notificationBrokerService);
                consSoaParam.setInterface(this.notificationBrokerInterface);
                consSoaParam.setEndpoint(this.notificationBrokerEdp);
                WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)consSoaParam, (ReferenceParametersType)consRefPar);
                response.setConsumerReference(consumerRef);
            }
            catch (WSAddressingException e) {
                throw new WSNotificationException(e);
            }
            catch (WSNotificationFault fault) {
                throw fault;
            }
        }
        return response;
    }

    @Override
    public DestroyRegistrationResponse destroyRegistration(DestroyRegistration request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        this.logger.log(Level.FINE, "performs a \"DestroyRegistration\" request ...");
        this.logger.log(Level.FINE, "\"DestroyRegistration\" method implementation in progress !");
        DestroyRegistrationResponse response = null;
        ResourcesUuidType registrationUuids = WsnSpecificTypeHelper.getResourcesUuidType((DestroyRegistration)request);
        if (registrationUuids != null) {
            List resourcesId = registrationUuids.getUuids();
            if (resourcesId != null) {
                for (String rId : resourcesId) {
                    if (this.registrations.containsKey(rId)) {
                        this.registrations.remove(rId);
                        if (this.registrations.containsKey(rId)) {
                            throw new ResourceNotDestroyedFault("eng", "The PublisherRegistrationManager was unable to destroy the PublisherRegistration resource for some reason");
                        }
                        this.topicsMgr.removeExistingRegistration(rId);
                        if (this.persistenceMgr == null) continue;
                        this.persistenceMgr.removeRegistration(rId);
                        continue;
                    }
                    throw new ResourceUnknownFault("eng", "The PublisherRegistration is a WS-Resource, and the resource identified in the message is not known to the Web service.");
                }
            }
        } else {
            throw new ResourceNotDestroyedFault("eng", "The PublisherRegistrationManager was unable to destroy the PublisherRegistration resource for some reason");
        }
        response = WSNotificationFactory.getInstance().createDestroyRegistrationResponse();
        return response;
    }

    public void restorePersistedRegistration() throws WSNotificationException, WSNotificationFault {
        if (this.persistenceMgr != null) {
            Map<String, PublisherRegistrationRP> pubRegRPToRestore = this.persistenceMgr.getRegistrationsToRestore();
            Set<String> rIds = pubRegRPToRestore.keySet();
            PublisherRegistrationRP currentPubRegRP = null;
            List<TopicExpressionType> currentTopics = null;
            for (String idItem : rIds) {
                currentPubRegRP = pubRegRPToRestore.get(idItem);
                this.registrations.put(idItem, currentPubRegRP);
                currentTopics = currentPubRegRP.getTopic();
                for (TopicExpressionType topExpItem : currentTopics) {
                    this.topicsMgr.storeNewRegistration(topExpItem, idItem);
                }
            }
        }
    }
}

