/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy;

import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.ow2.petals.binding.restproxy.SUManager;
import org.ow2.petals.binding.restproxy.in.ListService;
import org.ow2.petals.binding.restproxy.in.REST2JBIService;
import org.ow2.petals.binding.restproxy.in.RESTEngineContext;
import org.ow2.petals.binding.restproxy.in.RESTProxyService;
import org.ow2.petals.binding.restproxy.in.StatsService;
import org.ow2.petals.binding.restproxy.in.server.RESTServerJob;
import org.ow2.petals.binding.restproxy.out.CommonsHTTPClient;
import org.ow2.petals.component.framework.ComponentInformation;
import org.ow2.petals.component.framework.PetalsBindingComponent;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.messaging.framework.Engine;
import org.ow2.petals.messaging.framework.EngineException;
import org.ow2.petals.messaging.framework.EngineFactory;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycleException;
import org.ow2.petals.messaging.framework.message.Callback;
import org.ow2.petals.messaging.framework.message.Client;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.message.MessageImpl;
import org.ow2.petals.messaging.framework.message.MessagingEngine;
import org.ow2.petals.messaging.framework.message.MessagingEngineImpl;
import org.ow2.petals.messaging.framework.message.MessagingException;
import org.ow2.petals.messaging.framework.message.mime.ReaderRegistry;
import org.ow2.petals.messaging.framework.message.mime.WriterRegistry;
import org.ow2.petals.messaging.framework.message.mime.reader.ApplicationXMLReader;
import org.ow2.petals.messaging.framework.message.mime.reader.RawReader;
import org.ow2.petals.messaging.framework.message.mime.reader.TextHTMLReader;
import org.ow2.petals.messaging.framework.message.mime.reader.TextPlainReader;
import org.ow2.petals.messaging.framework.message.mime.reader.TextXMLReader;
import org.ow2.petals.messaging.framework.message.mime.reader.XwwwFormURLEncodedReader;
import org.ow2.petals.messaging.framework.message.mime.writer.TextHTMLWriter;
import org.ow2.petals.messaging.framework.message.mime.writer.TextPlainWriter;
import org.ow2.petals.messaging.framework.message.mime.writer.TextXMLWriter;
import org.ow2.petals.messaging.framework.plugins.job.JobManager;
import org.ow2.petals.messaging.framework.plugins.service.ServiceManager;

public class Component
extends PetalsBindingComponent
implements Client {
    protected void postDoInit() throws JBIException {
        this.configureEngine();
        try {
            EngineFactory.getEngine().init();
        }
        catch (LifeCycleException e) {
            e.printStackTrace();
        }
    }

    private void configureEngine() {
        String tmp;
        String proxyPath;
        Engine engine = EngineFactory.getEngine();
        RESTEngineContext context = new RESTEngineContext();
        try {
            engine.addComponent(RESTEngineContext.class, (Object)context);
        }
        catch (EngineException e3) {
            e3.printStackTrace();
        }
        String path = this.getComponentExtensions().get((Object)"path");
        if (path == null) {
            path = "petals/rest/service";
        }
        if (path.trim().length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        if ((proxyPath = this.getComponentExtensions().get((Object)"proxy")) == null) {
            proxyPath = "petals/rest/proxy";
        }
        if (proxyPath.trim().length() > 0 && proxyPath.charAt(0) != '/') {
            proxyPath = "/" + proxyPath;
        }
        int port = 8787;
        String containerPort = this.getContainerConfiguration("port");
        if (containerPort != null) {
            try {
                port = Integer.parseInt(containerPort.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == 8787 && (tmp = this.getComponentExtensions().get((Object)"port")) != null) {
            try {
                port = Integer.parseInt(tmp.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        context.setProxyPath(proxyPath);
        context.setServicePath(path);
        context.setPort(port);
        ServiceManager serviceManager = new ServiceManager();
        serviceManager.add("/list/*", (LifeCycle)new ListService());
        serviceManager.add("/stats/*", (LifeCycle)new StatsService());
        serviceManager.add(String.valueOf(proxyPath) + "/*", (LifeCycle)new RESTProxyService());
        serviceManager.add(String.valueOf(path) + "/*", (LifeCycle)new REST2JBIService());
        try {
            engine.addComponent(ServiceManager.class, (Object)serviceManager);
        }
        catch (EngineException e3) {
            e3.printStackTrace();
        }
        JobManager jobManager = new JobManager();
        jobManager.add("RESTSERVERJob", (LifeCycle)new RESTServerJob());
        try {
            engine.addComponent(JobManager.class, (Object)jobManager);
        }
        catch (EngineException engineException) {
            // empty catch block
        }
        MessagingEngineImpl mEngine = new MessagingEngineImpl();
        try {
            mEngine.addClient("http", (Client)new CommonsHTTPClient(this.getLogger()));
        }
        catch (EngineException e1) {
            e1.printStackTrace();
        }
        try {
            mEngine.addClient("jbi", (Client)this);
        }
        catch (EngineException e1) {
            e1.printStackTrace();
        }
        try {
            engine.addComponent(MessagingEngine.class, (Object)mEngine);
        }
        catch (EngineException e1) {
            e1.printStackTrace();
        }
        ReaderRegistry readers = new ReaderRegistry();
        readers.put((Object)"application/x-www-form-urlencoded", (Object)new XwwwFormURLEncodedReader());
        readers.put((Object)"text/xml", (Object)new TextXMLReader());
        readers.put((Object)"application/xml", (Object)new ApplicationXMLReader());
        readers.put((Object)"text/html", (Object)new TextHTMLReader());
        readers.put((Object)"text/plain", (Object)new TextPlainReader());
        readers.put((Object)"RAW", (Object)new RawReader());
        try {
            engine.addComponent(ReaderRegistry.class, (Object)readers);
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        WriterRegistry writers = new WriterRegistry();
        writers.put((Object)"text/xml", (Object)new TextXMLWriter());
        writers.put((Object)"text/plain", (Object)new TextPlainWriter());
        writers.put((Object)"text/html", (Object)new TextHTMLWriter());
        writers.put((Object)"application/xml", (Object)new TextXMLWriter());
        writers.put((Object)"RAW", (Object)new TextPlainWriter());
        try {
            engine.addComponent(WriterRegistry.class, (Object)writers);
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
    }

    protected void doStart() throws JBIException {
        RESTEngineContext context = (RESTEngineContext)EngineFactory.getEngine().getComponent(RESTEngineContext.class);
        String proxy = "http://$HOST:" + context.getPort() + context.getProxyPath();
        String service = "http://$HOST:" + context.getPort() + context.getServicePath();
        this.getPlugin(ComponentInformation.class).addProperty("proxy", proxy);
        this.getPlugin(ComponentInformation.class).addProperty("service", service);
        try {
            EngineFactory.getEngine().start();
        }
        catch (LifeCycleException e) {
            e.printStackTrace();
        }
    }

    protected void doStop() throws JBIException {
        try {
            EngineFactory.getEngine().stop();
        }
        catch (LifeCycleException e) {
            e.printStackTrace();
        }
    }

    public Message send(Message message) throws MessagingException {
        Exchange exchange = null;
        try {
            exchange = this.createMessageExchange();
            if (message.getContent(Source.class) != null) {
                exchange.setInMessageContent((Source)message.getContent(Source.class));
            }
            exchange.setProperty("wsa:to", message.get("com.ebmwebsourcing.commons.ws.framework.httpURL"));
            exchange.setOperation((QName)message.get("com.ebmwebsourcing.commons.ws.framework.Operation"));
            exchange.setService((QName)message.get("com.ebmwebsourcing.commons.ws.framework.Service"));
            exchange.setInterfaceName((QName)message.get("com.ebmwebsourcing.commons.ws.framework.Interface"));
            for (String key : message.getAll().keySet()) {
                exchange.setInMessageProperty(key, message.get(key));
            }
        }
        catch (Exception e) {
            String errorMsg = "Error while transforming request to JBI MessageExchange";
            throw new MessagingException("Error while transforming request to JBI MessageExchange", (Throwable)e);
        }
        boolean sent = false;
        try {
            sent = this.getChannel().sendSync(((ExchangeImpl)exchange).getMessageExchange());
        }
        catch (javax.jbi.messaging.MessagingException e) {
            String errorMsg = "Error while sending message through JBI NMR.";
            throw new MessagingException("Error while sending message through JBI NMR.", (Throwable)e);
        }
        if (!sent) {
            String errorMsg = "A timeout occurs calling the consumed service.";
            throw new MessagingException(errorMsg);
        }
        return this.processResponse(exchange);
    }

    public void send(Message in, Callback callback) throws MessagingException {
        throw new MessagingException("Not implemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Message processResponse(Exchange exchange) throws MessagingException {
        this.getLogger().fine("Processing response for status " + exchange.getStatus());
        MessageImpl result = new MessageImpl();
        if (exchange.isDoneStatus()) {
            this.getLogger().fine("Done status");
            return null;
        }
        if (exchange.isErrorStatus()) {
            throw new MessagingException((Throwable)exchange.getError());
        }
        if (!exchange.isActiveStatus()) throw new MessagingException("Bad exchange status");
        try {
            if (exchange.getOutMessage() != null) {
                NormalizedMessage nm = exchange.getOutMessage();
                if (nm == null) {
                    String errorMsg = "The MEP '" + exchange.getPattern() + "' does not accept a null response";
                    throw new MessagingException(errorMsg);
                }
                result = this.createMessage(nm);
                return result;
            } else {
                if (exchange.getFault() == null) return result;
                result = this.createMessage((NormalizedMessage)exchange.getFault());
            }
            return result;
        }
        finally {
            this.closeMessageExchange(exchange);
        }
    }

    private Message createMessage(NormalizedMessage nm) {
        MessageImpl result = new MessageImpl();
        result.setContent(Source.class, (Object)nm.getContent());
        Set props = nm.getPropertyNames();
        if (props != null) {
            for (Object object : props) {
                String key = object.toString();
                this.getLogger().fine("Setting property " + key);
                result.put(key, (Object)nm.getProperty(key).toString());
            }
        }
        return result;
    }

    protected void closeMessageExchange(Exchange exchange) throws MessagingException {
        try {
            exchange.setDoneStatus();
            this.getChannel().send(((ExchangeImpl)exchange).getMessageExchange());
        }
        catch (javax.jbi.messaging.MessagingException e) {
            String errorMsg = "Error while closing JBI MessageExchange.";
            throw new MessagingException("Error while closing JBI MessageExchange.", (Throwable)e);
        }
    }

    protected Exchange createMessageExchange() throws javax.jbi.messaging.MessagingException {
        MessageExchangeFactory factory = this.getChannel().createExchangeFactory();
        MessageExchange exchange = factory.createExchange(Message.MEPConstants.IN_OUT_PATTERN.value());
        return new ExchangeImpl(exchange);
    }

    protected AbstractServiceUnitManager createServiceUnitManager() {
        return new SUManager(this);
    }
}

