/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy.in;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.ow2.petals.binding.restproxy.Constants;
import org.ow2.petals.binding.restproxy.HTTPUtils;
import org.ow2.petals.binding.restproxy.IOUtils;
import org.ow2.petals.binding.restproxy.RESTException;
import org.ow2.petals.binding.restproxy.in.HTTPServletProxy;
import org.ow2.petals.binding.restproxy.in.RESTEngineContext;
import org.ow2.petals.messaging.framework.Engine;
import org.ow2.petals.messaging.framework.EngineFactory;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.message.MessageImpl;
import org.ow2.petals.messaging.framework.message.MessagingEngine;
import org.ow2.petals.messaging.framework.message.MessagingException;
import org.ow2.petals.messaging.framework.message.mime.Reader;
import org.ow2.petals.messaging.framework.message.mime.ReaderRegistry;
import org.ow2.petals.messaging.framework.message.mime.Writer;
import org.ow2.petals.messaging.framework.message.mime.WriterRegistry;
import org.ow2.petals.messaging.framework.message.mime.reader.ReaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTHandler
implements HTTPServletProxy {
    final Logger logger;

    public RESTHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void proxify(String destination, HttpServletRequest request, HttpServletResponse response) {
        this.logger.fine("Proxy call to " + destination);
        String newTarget = this.fixTarget(destination);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Initial destination was '" + destination + "'");
            this.logger.fine("Final destination is '" + newTarget + "'");
        }
        try {
            try {
                this.validatePath(newTarget);
                this.process(newTarget, "RESTEndpoint", Constants.SERVICE_NAME, Constants.INTERFACE_NAME, request, response);
            }
            catch (RESTException e) {
                try {
                    HTTPUtils.writeXMLError(e, (OutputStream)response.getOutputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    IOUtils.flushAndCose((OutputStream)response.getOutputStream());
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                IOUtils.flushAndCose((OutputStream)response.getOutputStream());
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void invoke(String serviceName, String path, HttpServletRequest request, HttpServletResponse response) {
        this.logger.fine("Invoke service for " + serviceName + " and path '" + path + "'");
        Engine engine = EngineFactory.getEngine();
        RESTEngineContext context = (RESTEngineContext)engine.getComponent(RESTEngineContext.class);
        if (context == null) {
            return;
        }
        RESTEngineContext.Consume consume = context.getRestConsumers().get(serviceName);
        if (consume == null) {
            try {
                try {
                    HTTPUtils.writeXMLError(new RESTException("No service '" + serviceName + "' has been found in the REST component"), (OutputStream)response.getOutputStream());
                }
                catch (IOException iOException) {}
            }
            finally {
                try {
                    IOUtils.flushAndCose((OutputStream)response.getOutputStream());
                }
                catch (IOException iOException) {}
            }
        } else {
            try {
                try {
                    this.process(path, consume.getEndpointName(), consume.getServiceName(), consume.getInterfaceName(), request, response);
                }
                catch (RESTException e) {
                    try {
                        HTTPUtils.writeXMLError(e, (OutputStream)response.getOutputStream());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        IOUtils.flushAndCose((OutputStream)response.getOutputStream());
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    IOUtils.flushAndCose((OutputStream)response.getOutputStream());
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String fixTarget(String target) {
        String result = target;
        if (result != null && result.contains("http:/") && !result.contains("http://")) {
            result = result.replaceAll("http:/", "http://");
        }
        return result;
    }

    private void writeResponse(Message message, HttpServletResponse response) throws RESTException {
        block20: {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Available properties = " + message.getAll());
            }
            Object o = message.get("com.ebmwebsourcing.commons.ws.framework.header.Content-Type");
            String contentType = null;
            if (o != null) {
                contentType = (String)o;
            }
            if (contentType == null) {
                contentType = "text/plain";
            }
            contentType = HTTPUtils.getContentType(contentType);
            o = message.get("com.ebmwebsourcing.commons.ws.framework.Charset-Encoding");
            String encoding = null;
            if (o != null) {
                encoding = (String)o;
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            this.setResponseHeaders(response, message);
            int status = 200;
            if (message.get("Status-Code") != null) {
                try {
                    status = Integer.parseInt((String)message.get("Status-Code"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Response Status is set to : " + status);
            }
            response.setStatus(status);
            WriterRegistry writers = (WriterRegistry)EngineFactory.getEngine().getComponent(WriterRegistry.class);
            if (writers != null && writers.get((Object)contentType) != null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Building response for content type = " + contentType);
                }
                try {
                    byte[] toWrite = ((Writer)writers.get((Object)contentType)).getBytes(message, encoding);
                    if (toWrite == null) {
                        this.logger.fine("No content to write to output stream");
                        break block20;
                    }
                    ServletOutputStream os = response.getOutputStream();
                    os.write(toWrite);
                }
                catch (Exception e) {
                    try {
                        HTTPUtils.writeXMLError(new RESTException(e), (OutputStream)response.getOutputStream());
                    }
                    catch (IOException e1) {
                        this.logger.warning(e1.getMessage());
                    }
                }
            } else {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("No message writer found for content type = " + contentType);
                }
                try {
                    HTTPUtils.writeXMLError(new RESTException("Can not find any message writer for type " + contentType), (OutputStream)response.getOutputStream());
                }
                catch (IOException e) {
                    this.logger.warning(e.getMessage());
                }
            }
        }
    }

    private void setResponseHeaders(HttpServletResponse response, Message message) {
        for (String key : message.getAll().keySet()) {
            if (!this.isValidResponseHeaderProperty(key) || message.getAll().get(key) == null) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Key " + key + " is valid and will be set in the HTTP response");
            }
            response.setHeader(key, message.get(key).toString());
        }
        response.setHeader("Server", "PEtALS ESB REST Proxy");
    }

    private boolean isValidResponseHeaderProperty(String key) {
        boolean result = true;
        if (key != null && key.startsWith("com.ebmwebsourcing.commons.ws.framework.header")) {
            if (key.endsWith("Server")) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    protected void validatePath(String path) throws RESTException {
        try {
            new URL(path);
        }
        catch (MalformedURLException e) {
            throw new RESTException("Invalid URL " + path);
        }
    }

    public void process(String path, String endpointName, QName serviceName, QName interfaceName, HttpServletRequest request, HttpServletResponse response) throws RESTException {
        ReaderRegistry readers;
        Message out = null;
        MessageImpl message = new MessageImpl();
        String contentType = HTTPUtils.getContentType(request.getContentType());
        if (contentType == null) {
            contentType = "RAW";
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Content type is null, setting default : " + contentType);
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Initial content type is : " + contentType);
        }
        String encoding = this.getEncoding(request);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Char encoding is : " + encoding);
        }
        if ((readers = (ReaderRegistry)EngineFactory.getEngine().getComponent(ReaderRegistry.class)) != null && readers.get((Object)contentType) != null) {
            try {
                message = ((Reader)readers.get((Object)contentType)).read((InputStream)request.getInputStream(), encoding);
            }
            catch (ReaderException e) {
                throw new RESTException(e);
            }
            catch (IOException e) {
                throw new RESTException(e);
            }
            message.putAll(this.createProperties(path, request));
            try {
                message.put("com.ebmwebsourcing.commons.ws.framework.Operation", (Object)QName.valueOf(request.getMethod().toUpperCase()));
                message.put("com.ebmwebsourcing.commons.ws.framework.Service", (Object)serviceName);
                message.put("com.ebmwebsourcing.commons.ws.framework.Interface", (Object)interfaceName);
                message.put("com.ebmwebsourcing.commons.ws.framework.Protocol", (Object)"jbi");
                MessagingEngine engine = (MessagingEngine)EngineFactory.getEngine().getComponent(MessagingEngine.class);
                if (engine != null) {
                    out = engine.send((Message)message);
                }
            }
            catch (MessagingException e) {
                throw new RESTException(e);
            }
            if (out == null) {
                throw new RESTException("No message response...");
            }
        } else {
            throw new RESTException("Can not find a valid reader for type '" + contentType + "'");
        }
        this.writeResponse(out, response);
    }

    private String getEncoding(HttpServletRequest request) {
        String charsetEncoding = request.getCharacterEncoding();
        if (charsetEncoding == null) {
            charsetEncoding = "UTF-8";
        }
        return charsetEncoding;
    }

    private Map<String, Object> createProperties(String path, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("com.ebmwebsourcing.commons.ws.framework.httpURL", path);
        Enumeration headers = request.getHeaderNames();
        if (headers != null) {
            while (headers.hasMoreElements()) {
                Object object = headers.nextElement();
                String key = object.toString();
                result.put("com.ebmwebsourcing.commons.ws.framework.header." + key, request.getHeader(key));
            }
        }
        result.put("com.ebmwebsourcing.commons.ws.framework.Content-Length", request.getContentLength());
        String contentType = HTTPUtils.getContentType(request.getContentType());
        result.put("com.ebmwebsourcing.commons.ws.framework.Content-Type", contentType);
        String charsetEncoding = request.getCharacterEncoding();
        result.put("com.ebmwebsourcing.commons.ws.framework.Charset-Encoding", charsetEncoding);
        result.put("com.ebmwebsourcing.commons.ws.framework.httpmethod", request.getMethod());
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            String[] values = request.getParameterValues(paramName.toString());
            int i = 0;
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                result.put("com.ebmwebsourcing.commons.ws.framework.parameters." + i++ + "." + paramName, string);
                ++n2;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            for (String key : result.keySet()) {
                this.logger.fine("From HTTPRequest : Property '" + key + "' = '" + result.get(key) + "'");
            }
        }
        return result;
    }
}

