/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy.out;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.ow2.petals.binding.restproxy.HTTPUtils;
import org.ow2.petals.binding.restproxy.RESTException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.ow2.petals.messaging.framework.EngineFactory;
import org.ow2.petals.messaging.framework.message.Callback;
import org.ow2.petals.messaging.framework.message.Client;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.message.MessageImpl;
import org.ow2.petals.messaging.framework.message.MessagingException;
import org.ow2.petals.messaging.framework.message.mime.Reader;
import org.ow2.petals.messaging.framework.message.mime.ReaderRegistry;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsHTTPClient
implements Client {
    private final Logger logger;

    public CommonsHTTPClient(Logger logger) {
        this.logger = logger;
    }

    public Message send(Message message) throws MessagingException {
        URL url = (URL)message.get("com.ebmwebsourcing.commons.ws.framework.httpURL");
        if (url == null) {
            throw new MessagingException("URL can not be found on message, please set the com.ebmwebsourcing.commons.ws.framework.httpURL property");
        }
        String method = (String)message.get("com.ebmwebsourcing.commons.ws.framework.httpmethod");
        MessageImpl result = new MessageImpl();
        if ("GET".equals(method)) {
            result = this.get(message, url);
        } else if ("POST".equals(method)) {
            result = this.post(message, url);
        } else if ("PUT".equals(method)) {
            result = this.put(message, url);
        } else if ("DELETE".equals(method)) {
            result = this.delete(message, url);
        } else {
            throw new MessagingException("This is not a valid HTTP method in REST style : " + method);
        }
        return result;
    }

    protected Message delete(Message message, URL url) throws MessagingException {
        String contentType;
        Message result = null;
        HttpDelete method = new HttpDelete(url.toString());
        this.setParameters((HttpRequestBase)method, message.getAll());
        String contentEncoding = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Charset-Encoding");
        if (contentEncoding == null) {
            contentEncoding = "UTF-8";
        }
        if ((contentType = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Content-Type")) == null) {
            contentType = "text/xml";
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Outgoing Content-Type will be " + contentType);
            this.logger.fine("Outgoing Charset-Encoding will be " + contentEncoding);
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            try {
                HttpResponse response = httpclient.execute((HttpUriRequest)method);
                result = this.handleResponse(response);
            }
            catch (Exception e) {
                throw new MessagingException("Failed to invoke DELETE", (Throwable)e);
            }
        }
        finally {
            this.cleanup((HttpClient)httpclient);
        }
        return result;
    }

    protected Message post(Message message, URL url) throws MessagingException {
        AbstractHttpEntity entity;
        String contentType;
        Message result = null;
        HttpPost method = new HttpPost(url.toString());
        this.setParameters((HttpRequestBase)method, message.getAll());
        String contentEncoding = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Charset-Encoding");
        if (contentEncoding == null) {
            contentEncoding = "UTF-8";
        }
        if ((contentType = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Content-Type")) == null) {
            contentType = "text/xml";
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Outgoing Content-Type will be " + contentType);
            this.logger.fine("Outgoing Charset-Encoding will be " + contentEncoding);
        }
        if ((entity = this.createEntity(message, contentEncoding, contentType)) != null) {
            method.setEntity((HttpEntity)entity);
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            try {
                HttpResponse response = httpclient.execute((HttpUriRequest)method);
                result = this.handleResponse(response);
            }
            catch (Exception e) {
                throw new MessagingException("Failed to invoke POST", (Throwable)e);
            }
        }
        finally {
            this.cleanup((HttpClient)httpclient);
        }
        return result;
    }

    protected Message get(Message message, URL url) throws MessagingException {
        Message result = null;
        HttpGet method = new HttpGet(url.toString());
        this.setParameters((HttpRequestBase)method, message.getAll());
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            try {
                HttpResponse response = httpclient.execute((HttpUriRequest)method);
                result = this.handleResponse(response);
            }
            catch (Exception e) {
                throw new MessagingException("Failed to invoke GET", (Throwable)e);
            }
        }
        finally {
            this.cleanup((HttpClient)httpclient);
        }
        return result;
    }

    private void cleanup(HttpClient method) {
    }

    private Message handleResponse(HttpResponse response) throws RESTException {
        ReaderRegistry readers;
        if (response == null) {
            throw new RESTException("HTTP response is null!");
        }
        Header header = response.getFirstHeader("Content-Type");
        String contentType = "text/plain";
        if (header != null) {
            contentType = header.getValue();
        }
        contentType = HTTPUtils.getContentType(contentType);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Response content type is set to : " + contentType);
        }
        if ((readers = (ReaderRegistry)EngineFactory.getEngine().getComponent(ReaderRegistry.class)) == null || readers.get((Object)contentType) == null) {
            throw new RESTException("Can not find a valid handler for content type " + contentType);
        }
        String encoding = null;
        if (response.getEntity() != null) {
            header = response.getEntity().getContentEncoding();
        }
        if ((encoding = header == null ? "UTF-8" : header.getValue()) == null) {
            encoding = "UTF-8";
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Response content encoding is set to : " + encoding);
        }
        Object result = null;
        try {
            result = response.getEntity() != null ? ((Reader)readers.get((Object)contentType)).read(response.getEntity().getContent(), encoding) : new MessageImpl();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Handling problem", e);
            }
            throw new RESTException(e.getMessage());
        }
        this.addProperties(response, (Message)result);
        return result;
    }

    private void addProperties(HttpResponse response, Message message) throws RESTException {
        Header[] headers;
        Header[] headerArray = headers = response.getAllHeaders();
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            message.put("com.ebmwebsourcing.commons.ws.framework.header." + header.getName(), (Object)header.getValue());
            ++n2;
        }
        message.put("Status-Code", (Object)("" + response.getStatusLine().getStatusCode()));
        if (this.logger.isLoggable(Level.FINE)) {
            for (String key : message.getAll().keySet()) {
                this.logger.fine("From HTTP Client response : Property '" + key + "' = '" + message.get(key) + "'");
            }
        }
    }

    private Source getResultAsXML(HttpResponse response) {
        StreamSource result = null;
        try {
            InputStream in;
            if (response != null && (in = response.getEntity().getContent()) != null) {
                Header contentEncoding = response.getFirstHeader("Content-Encoding");
                if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                    in = new GZIPInputStream(in);
                }
                Document doc = XMLUtil.loadDocument(in);
                result = UtilFactory.getSourceUtil().createStreamSource(doc);
            }
        }
        catch (Exception e) {
            this.logger.warning(e.getMessage());
        }
        return result;
    }

    protected void setParameters(HttpRequestBase method, Map<String, Object> properties) {
        BasicHttpParams params = new BasicHttpParams();
        for (String key : properties.keySet()) {
            if (!this.isParamaterKey(key)) continue;
            String paramName = this.getParamName(key);
            Object paramValue = properties.get(key);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Adding HTTP parameter '" + paramName + "' with value '" + paramValue + "'");
            }
            params.setParameter(paramName, properties.get(key));
        }
        method.setParams((HttpParams)params);
    }

    private String getParamName(String key) {
        String result = null;
        if (key != null && key.startsWith("com.ebmwebsourcing.commons.ws.framework.parameters")) {
            result = key.substring("com.ebmwebsourcing.commons.ws.framework.parameters".length() + 1, key.length());
            result = result.substring(result.indexOf(".") + 1, result.length());
        }
        return result;
    }

    private boolean isParamaterKey(String key) {
        return key != null && key.startsWith("com.ebmwebsourcing.commons.ws.framework.parameters");
    }

    protected Message put(Message message, URL url) throws MessagingException {
        String contentType;
        Message result = null;
        HttpPut method = new HttpPut(url.toString());
        this.setParameters((HttpRequestBase)method, message.getAll());
        String contentEncoding = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Charset-Encoding");
        if (contentEncoding == null) {
            contentEncoding = "UTF-8";
        }
        if ((contentType = (String)message.get("com.ebmwebsourcing.commons.ws.framework.Content-Type")) == null) {
            contentType = "text/xml";
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Outgoing Content-Type will be " + contentType);
            this.logger.fine("Outgoing Charset-Encoding will be " + contentEncoding);
        }
        AbstractHttpEntity entity = this.createEntity(message, contentEncoding, contentType);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Content type is set to " + contentType);
            this.logger.fine("Content encoding is set to " + contentEncoding);
        }
        if (entity != null) {
            method.setEntity((HttpEntity)entity);
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            try {
                HttpResponse response = httpclient.execute((HttpUriRequest)method);
                result = this.handleResponse(response);
            }
            catch (Exception e) {
                throw new MessagingException("Failed to invoke PUT", (Throwable)e);
            }
        }
        finally {
            this.cleanup((HttpClient)httpclient);
        }
        return result;
    }

    private AbstractHttpEntity createEntity(Message message, String contentEncoding, String contentType) throws MessagingException {
        UrlEncodedFormEntity entity = null;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Creating entity for content type : " + contentType);
        }
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            for (String key : message.getAll().keySet()) {
                if (!this.isParamaterKey(key)) continue;
                String paramName = this.getParamName(key);
                Object o = message.getAll().get(key);
                String paramValue = null;
                paramValue = o == null ? "" : o.toString();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Adding HTTP Form parameter '" + paramName + "' with value '" + paramValue + "'");
                }
                formparams.add(new BasicNameValuePair(paramName, paramValue));
            }
            try {
                entity = new UrlEncodedFormEntity(formparams, contentEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException(e.getMessage());
            }
        }
        if (("text/xml".equals(contentType) || "application/soap+xml".equals(contentType)) && message != null && message.getContent(Source.class) != null) {
            String payload = null;
            try {
                payload = UtilFactory.getSourceUtil().createString((Source)message.getContent(Source.class));
            }
            catch (PEtALSCDKException e) {
                this.logger.warning(e.getMessage());
            }
            try {
                entity = new StringEntity(payload, contentEncoding);
                entity.setContentType(String.valueOf(contentType) + "; charset=" + contentEncoding);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warning(e.getMessage());
            }
        }
        return entity;
    }

    public void send(Message in, Callback callback) throws MessagingException {
        throw new MessagingException("Not implemented");
    }
}

