/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.messaging.framework.Engine;
import org.ow2.petals.messaging.framework.EngineException;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycleException;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineImpl
implements Engine {
    private static Log logger = LogFactory.getLog(EngineImpl.class);
    private final Map<Class<?>, Object> plugins = new ConcurrentHashMap();
    boolean initCalled = false;
    private LifeCycle.STATE state = LifeCycle.STATE.STOPPED;

    protected EngineImpl() {
    }

    @Override
    public void init() throws LifeCycleException {
        LifeCycleManager lifeCycleManager;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Initializing engine");
        }
        if (null != (lifeCycleManager = this.getComponent(LifeCycleManager.class))) {
            lifeCycleManager.preInit();
        }
        List<LifeCycle> pluginsToInit = this.getComponents(LifeCycle.class);
        for (LifeCycle lifeCycle : pluginsToInit) {
            try {
                lifeCycle.init();
            }
            catch (LifeCycleException e) {
                e.printStackTrace();
            }
        }
        if (null != lifeCycleManager) {
            lifeCycleManager.postInit();
        }
        this.state = LifeCycle.STATE.INITIALIZED;
    }

    @Override
    public synchronized void start() throws LifeCycleException {
        LifeCycleManager lifeCycleManager;
        if (!this.initCalled) {
            this.init();
        }
        if (null != (lifeCycleManager = this.getComponent(LifeCycleManager.class))) {
            lifeCycleManager.preStart();
        }
        List<LifeCycle> pluginsToStart = this.getComponents(LifeCycle.class);
        for (LifeCycle lifeCycle : pluginsToStart) {
            try {
                lifeCycle.start();
            }
            catch (LifeCycleException e) {
                e.printStackTrace();
            }
        }
        if (null != lifeCycleManager) {
            lifeCycleManager.postStart();
        }
        this.state = LifeCycle.STATE.STARTED;
    }

    @Override
    public synchronized void stop() {
        LifeCycleManager lifeCycleManager = this.getComponent(LifeCycleManager.class);
        if (null != lifeCycleManager) {
            lifeCycleManager.preStop();
        }
        List<LifeCycle> pluginsToStop = this.getComponents(LifeCycle.class);
        for (LifeCycle lifeCycle : pluginsToStop) {
            try {
                lifeCycle.stop();
            }
            catch (LifeCycleException e) {
                e.printStackTrace();
            }
        }
        if (null != lifeCycleManager) {
            lifeCycleManager.postStop();
        }
        this.state = LifeCycle.STATE.STOPPED;
    }

    private boolean isStarted() {
        return LifeCycle.STATE.STARTED.equals((Object)this.getState());
    }

    @Override
    public <T> void addComponent(Class<T> type, T plugin) throws EngineException {
        if (this.isStarted()) {
            throw new EngineException("Can not add plugin if engine is started");
        }
        if (type == null || plugin == null) {
            throw new EngineException("Can not add null plugin");
        }
        this.plugins.put(type, plugin);
    }

    @Override
    public <T> T getComponent(Class<T> type) {
        Object o = this.plugins.get(type);
        if (o != null) {
            return type.cast(o);
        }
        return null;
    }

    @Override
    public <T> List<T> getComponents(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object o : this.plugins.values()) {
            if (o == null) continue;
            try {
                T object = type.cast(o);
                result.add(object);
            }
            catch (Exception e) {}
        }
        return result;
    }

    @Override
    public LifeCycle.STATE getState() {
        return this.state;
    }
}

