/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.message.mime.reader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.message.MessageImpl;
import org.ow2.petals.messaging.framework.message.mime.Reader;
import org.ow2.petals.messaging.framework.message.mime.reader.ReaderException;

public class TextHTMLReader
implements Reader {
    public Message read(InputStream inputStream, String encoding) throws ReaderException {
        MessageImpl message = new MessageImpl();
        String htmlAsString = null;
        try {
            htmlAsString = this.getStreamAsString(inputStream);
        }
        catch (IOException e) {
            throw new ReaderException("Can not read the stream", e);
        }
        message.put("rawdata", htmlAsString);
        return message;
    }

    private String getStreamAsString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int read = inputStream.read(buf);
        while (read != -1) {
            out.write(buf, 0, read);
            read = inputStream.read(buf);
        }
        return new String(out.toByteArray());
    }
}

