/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.messaging.framework.plugins;

import java.util.HashMap;
import java.util.Map;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycleException;
import org.ow2.petals.messaging.framework.plugins.Manager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManager<T extends LifeCycle>
implements Manager<T> {
    protected final Map<String, T> managedObjects = new HashMap<String, T>();
    protected LifeCycle.STATE state = LifeCycle.STATE.STOPPED;

    @Override
    public void add(String name, T managed) {
        this.managedObjects.put(name, managed);
    }

    @Override
    public void delete(String name) {
        this.managedObjects.remove(name);
    }

    @Override
    public int size() {
        return this.managedObjects.size();
    }

    @Override
    public void init() {
        for (LifeCycle managed : this.managedObjects.values()) {
            if (managed == null) continue;
            try {
                managed.init();
            }
            catch (LifeCycleException e) {
                e.printStackTrace();
            }
        }
        this.state = LifeCycle.STATE.INITIALIZED;
    }

    @Override
    public void start() {
        for (LifeCycle managed : this.managedObjects.values()) {
            if (managed == null) continue;
            try {
                managed.start();
            }
            catch (LifeCycleException e) {
                e.printStackTrace();
            }
        }
        this.state = LifeCycle.STATE.STARTED;
    }

    @Override
    public void stop() {
        for (LifeCycle managed : this.managedObjects.values()) {
            if (managed == null) continue;
            try {
                managed.stop();
            }
            catch (LifeCycleException e) {
                e.printStackTrace();
            }
        }
        this.state = LifeCycle.STATE.STOPPED;
    }

    @Override
    public LifeCycle.STATE getState() {
        return this.state;
    }

    public Map<String, T> getManagedObjects() {
        return this.managedObjects;
    }
}

